/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class TrainerCardColorPacket
extends AbstractPixelmonPacket {
    private EnumTrainerCardColor color;

    public TrainerCardColorPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public TrainerCardColorPacket(EnumTrainerCardColor color) {
        super(PacketDirection.PLAY_SERVER, true);
        this.color = color;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.color = EnumTrainerCardColor.values()[buf.readShort()];
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeShort(this.color.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party = StorageProxy.getParty(context.getSender());
        party.trainerCardColor = this.color == null ? EnumTrainerCardColor.WHITE : this.color;
    }
}

