/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.selection.PartySelectionFactory;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SelectionResponsePacket
extends AbstractPixelmonPacket {
    private List<Integer> selected;

    public SelectionResponsePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public SelectionResponsePacket(List<Integer> selected) {
        this();
        this.selected = selected;
    }

    @Override
    public void decode(PacketBuffer buf) {
        if (!buf.readBoolean()) {
            this.selected = null;
            return;
        }
        this.selected = Lists.newArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.selected.add(buf.readInt());
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.selected != null);
        if (this.selected == null) {
            return;
        }
        buf.writeInt(this.selected.size());
        for (Integer integer : this.selected) {
            buf.writeInt(integer.intValue());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (context.getSender() == null) {
            return;
        }
        if (!PartySelectionFactory.inSelection(context.getSender())) {
            return;
        }
        PartySelectionFactory.SelectionData selectionConsumer = PartySelectionFactory.getSelectionConsumer(context.getSender());
        if (selectionConsumer == null) {
            return;
        }
        if (this.selected == null) {
            if (selectionConsumer.getConsumer() != null) {
                selectionConsumer.getConsumer().accept(context.getSender(), Collections.emptyList());
            }
            PartySelectionFactory.removeSelection(context.getSender());
            return;
        }
        List<Pokemon> pokemon = selectionConsumer.getPokemon();
        ArrayList selected = Lists.newArrayList();
        for (Integer integer : this.selected) {
            selected.add(pokemon.get(integer));
        }
        if (selectionConsumer.getConsumer() != null) {
            selectionConsumer.getConsumer().accept(context.getSender(), selected);
        }
        PartySelectionFactory.removeSelection(context.getSender());
    }
}

