/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseMoveSkillPacket
extends AbstractPixelmonPacket {
    private int selectedPixelmon;
    private MoveSkill moveSkill;
    private int entityID;
    private int x;
    private int y;
    private int z;
    private int side;
    private MoveSkill.EnumTargetType targetType;

    public UseMoveSkillPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.targetType = MoveSkill.EnumTargetType.NOTHING;
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill, int entityId, MoveSkill.EnumTargetType targetType) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.entityID = entityId;
        this.targetType = targetType;
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.side = side.func_176745_a();
        this.targetType = MoveSkill.EnumTargetType.BLOCK;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.selectedPixelmon = buf.readByte();
        this.moveSkill = MoveSkill.getMoveSkillByID(buf.func_218666_n());
        this.targetType = MoveSkill.EnumTargetType.values()[buf.readByte()];
        switch (this.targetType) {
            case MISC_ENTITY: 
            case PLAYER: 
            case POKEMON: {
                this.entityID = buf.readInt();
                break;
            }
            case BLOCK: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.side = buf.readInt();
                this.targetType = MoveSkill.EnumTargetType.BLOCK;
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.selectedPixelmon);
        buf.func_180714_a(this.moveSkill.id);
        buf.writeByte(this.targetType.ordinal());
        switch (this.targetType) {
            case MISC_ENTITY: 
            case PLAYER: 
            case POKEMON: {
                buf.writeInt(this.entityID);
                break;
            }
            case BLOCK: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.side);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        World world = context.getSender().field_70170_p;
        if (!PixelmonConfigProxy.getExternalMoves().isAllowExternalMoves()) {
            return;
        }
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (pokemon == null || !pokemon.getPixelmonEntity().isPresent()) {
            return;
        }
        PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
        if (pixelmon == null) {
            return;
        }
        MoveSkill moveSkill = this.moveSkill;
        if (moveSkill == null || !MoveSkill.getMoveSkills(pixelmon.getPokemon()).contains(moveSkill)) {
            return;
        }
        if (pixelmon.getPokemon().isMoveSkillCoolingDown(moveSkill)) {
            return;
        }
        if (this.targetType == MoveSkill.EnumTargetType.BLOCK) {
            pixelmon.setBlockTarget(this.x, this.y, this.z, Direction.values()[this.side], moveSkill.id);
        } else if (this.targetType != MoveSkill.EnumTargetType.NOTHING) {
            Entity entity = world.func_73045_a(this.entityID);
            if (entity instanceof LivingEntity) {
                pixelmon.setAttackTarget((LivingEntity)entity, moveSkill.id);
            }
        } else {
            moveSkill.onUsed(pixelmon, null, MoveSkill.EnumTargetType.NOTHING);
        }
    }
}

