/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RegisterMoveSkillPacket
extends AbstractPixelmonPacket {
    private MoveSkill moveSkill;
    private boolean unregister = false;

    public RegisterMoveSkillPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.moveSkill = moveSkill;
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill, boolean unregister) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.moveSkill = moveSkill;
        this.unregister = unregister;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.moveSkill = new MoveSkill(buf.func_218666_n());
        this.unregister = buf.readBoolean();
        if (!this.unregister) {
            String spec;
            String attack;
            int i;
            this.moveSkill.setName(buf.func_218666_n());
            int descCount = buf.readByte();
            for (int i2 = 0; i2 < descCount; ++i2) {
                this.moveSkill.descriptions.add(buf.func_218666_n());
            }
            this.moveSkill.sprite = ResourceLocationHelper.of(buf.func_218666_n());
            this.moveSkill.anyMoves = Sets.newHashSet();
            int n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                attack = buf.func_218666_n();
                this.moveSkill.anyMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> AttackRegistry.getAttackBase(attack).orElse(null)));
            }
            this.moveSkill.combinationMoves = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                attack = buf.func_218666_n();
                this.moveSkill.combinationMoves.add((Lazy<ImmutableAttack>)Lazy.of(() -> AttackRegistry.getAttackBase(attack).orElse(null)));
            }
            this.moveSkill.ableSpecs = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                spec = buf.func_218666_n();
                this.moveSkill.ableSpecs.add((Lazy<PokemonSpecification>)Lazy.of(() -> PokemonSpecificationProxy.create(spec)));
            }
            this.moveSkill.intrinsicSpecs = Sets.newHashSet();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                spec = buf.func_218666_n();
                this.moveSkill.intrinsicSpecs.add((Lazy<PokemonSpecification>)Lazy.of(() -> PokemonSpecificationProxy.create(spec)));
            }
            this.moveSkill.behaviours = Maps.newHashMap();
            n = buf.readByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.behaviours.put(MoveSkill.EnumTargetType.values()[buf.readByte()], (pix, o) -> 1);
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.moveSkill.id);
        buffer.writeBoolean(this.unregister);
        if (!this.unregister) {
            buffer.func_180714_a(this.moveSkill.name);
            buffer.writeByte(this.moveSkill.descriptions.size());
            for (String string : this.moveSkill.descriptions) {
                buffer.func_180714_a(string);
            }
            buffer.func_180714_a(this.moveSkill.sprite.toString());
            buffer.writeByte(this.moveSkill.anyMoves.size());
            for (Lazy lazy : this.moveSkill.anyMoves) {
                buffer.func_180714_a(((ImmutableAttack)lazy.get()).getAttackName());
            }
            buffer.writeByte(this.moveSkill.combinationMoves.size());
            for (Lazy lazy : this.moveSkill.combinationMoves) {
                buffer.func_180714_a(((ImmutableAttack)lazy.get()).getAttackName());
            }
            buffer.writeByte(this.moveSkill.ableSpecs.size());
            for (Lazy lazy : this.moveSkill.ableSpecs) {
                buffer.func_180714_a(((PokemonSpecification)lazy.get()).toString());
            }
            buffer.writeByte(this.moveSkill.intrinsicSpecs.size());
            for (Lazy lazy : this.moveSkill.intrinsicSpecs) {
                buffer.func_180714_a(((PokemonSpecification)lazy.get()).toString());
            }
            buffer.writeByte(this.moveSkill.behaviours.keySet().size());
            for (MoveSkill.EnumTargetType enumTargetType : this.moveSkill.behaviours.keySet()) {
                buffer.writeByte((int)((byte)enumTargetType.ordinal()));
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.moveSkills.removeIf(moveSkill -> moveSkill.id.equals(this.moveSkill.id));
        if (!this.unregister) {
            ClientProxy.moveSkills.add(this.moveSkill);
        }
    }
}

