/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.evolution;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.EvolveScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.TradingScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidCatchScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenEvolutionGUIPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String name;

    public OpenEvolutionGUIPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenEvolutionGUIPacket(UUID pokemonUUID, String name) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.pokemonUUID = pokemonUUID;
        this.name = name;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = buffer.func_179253_g();
        this.name = buffer.func_218666_n();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
        buffer.func_180714_a(this.name);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        boolean exists = false;
        for (int i = 0; i < ClientProxy.battleManager.evolveList.size(); ++i) {
            if (!ClientProxy.battleManager.evolveList.get((int)i).pokemonUUID.equals(this.pokemonUUID)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            ClientProxy.battleManager.evolveList.add(new EvoInfo(this.pokemonUUID, this.name));
        }
        if (!(!ClientProxy.battleManager.battleEnded || Minecraft.func_71410_x().field_71462_r instanceof BattleScreen || Minecraft.func_71410_x().field_71462_r instanceof TradingScreen || Minecraft.func_71410_x().field_71462_r instanceof ItemDropsScreen || Minecraft.func_71410_x().field_71462_r instanceof RaidCatchScreen)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new EvolveScreen());
        }
    }
}

