/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.editor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportRequestHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ImportResponsePacket
extends AbstractPixelmonPacket {
    private List<Pokemon> response;
    private String error;
    private String failedValue;

    public ImportResponsePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public ImportResponsePacket(List<Pokemon> response) {
        this();
        this.response = response;
    }

    public ImportResponsePacket(String error, String failedValue) {
        this();
        this.error = error;
        this.failedValue = failedValue;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.response == null);
        if (this.response == null) {
            buffer.func_180714_a(this.error);
            buffer.func_180714_a(this.failedValue);
        } else {
            buffer.writeInt(this.response.size());
            for (Pokemon pokemon : this.response) {
                pokemon.writeToByteBuffer(buffer, new EnumUpdateType[0]);
            }
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        boolean errorCode = buffer.readBoolean();
        if (errorCode) {
            this.error = buffer.func_218666_n();
            this.failedValue = buffer.func_218666_n();
        } else {
            int size = buffer.readInt();
            this.response = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                this.response.add(PokemonFactory.create(buffer));
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof ImportRequestHandler)) {
            return;
        }
        if (this.response != null) {
            ((ImportRequestHandler)Minecraft.func_71410_x().field_71462_r).handleResponse(this.response.toArray(new Pokemon[0]));
        } else {
            ((ImportRequestHandler)Minecraft.func_71410_x().field_71462_r).handleResponse(this.error, this.failedValue);
        }
    }
}

