/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class WithdrawDayCareBoxPacket
extends AbstractPixelmonPacket {
    private int boxId;

    public WithdrawDayCareBoxPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public WithdrawDayCareBoxPacket(int boxId) {
        this();
        this.boxId = boxId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.boxId);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.boxId = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        PlayerDayCare dayCare = StorageProxy.getParty(sender).getDayCare();
        if (dayCare == null) {
            return;
        }
        DayCareBox dayCareBox = dayCare.getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty() || !dayCareBox.hasBreedingBegun() || dayCareBox.getPercentComplete() < 100.0) {
            return;
        }
        dayCareBox.returnToStorage();
        this.reply(context, new UpdateDayCareBoxPacket(dayCareBox));
    }
}

