/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareConditionStatusResponsePacket;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DayCareRequestConditionUpdatePacket
extends AbstractPixelmonPacket {
    private int boxId;

    public DayCareRequestConditionUpdatePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DayCareRequestConditionUpdatePacket(int boxId) {
        this();
        this.boxId = boxId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.boxId);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.boxId = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party = StorageProxy.getParty(context.getSender());
        if (party == null) {
            return;
        }
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        DayCareCondition nextCondition = dayCareBox.getNextCondition();
        if (nextCondition == null) {
            return;
        }
        Optional<DayCareRequirement> nextRequirement = nextCondition.getNextRequirement();
        if (nextCondition.isComplete() || !nextRequirement.isPresent()) {
            return;
        }
        boolean canConsume = this.canConsume(context.getSender(), dayCareBox, nextRequirement.get());
        DayCareEvent.PreConditionStatusUpdate preEvent = new DayCareEvent.PreConditionStatusUpdate(context.getSender(), party, dayCareBox, nextCondition, nextRequirement.get(), canConsume, nextRequirement.get().getError());
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        this.reply(context, new DayCareConditionStatusResponsePacket(this.boxId, preEvent.getErrorMessage(), preEvent.isCanConsume()));
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostConditionStatusUpdate(context.getSender(), party, dayCareBox, preEvent.getCondition(), preEvent.getRequirement(), preEvent.isCanConsume(), preEvent.getErrorMessage()));
    }

    private boolean canConsume(ServerPlayerEntity player, DayCareBox box, DayCareRequirement requirement) {
        return requirement.hasMetRequirement(player, box);
    }
}

