/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareScreen;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DayCareConditionStatusResponsePacket
extends AbstractPixelmonPacket {
    private int boxId;
    private ITextComponent errorMessage;
    private boolean canConsume;

    public DayCareConditionStatusResponsePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DayCareConditionStatusResponsePacket(int boxId, ITextComponent errorMessage, boolean canConsume) {
        this();
        this.boxId = boxId;
        this.errorMessage = errorMessage;
        this.canConsume = canConsume;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.boxId);
        buffer.func_179256_a(this.errorMessage);
        buffer.writeBoolean(this.canConsume);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.boxId = buffer.readInt();
        this.errorMessage = buffer.func_179258_d();
        this.canConsume = buffer.readBoolean();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof DayCareScreen)) {
            return;
        }
        PlayerPartyStorage party = ClientStorageManager.party;
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        dayCareBox.setStatus(this.errorMessage, this.canConsume);
    }
}

