/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.BottlecapItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SelectStatPacket
extends AbstractPixelmonPacket {
    private int entityId;
    private BattleStatsType type;

    public SelectStatPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SelectStatPacket(int entityId, BattleStatsType type) {
        super(PacketDirection.PLAY_SERVER, true);
        this.entityId = entityId;
        this.type = type;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.entityId = buf.readInt();
        this.type = BattleStatsType.getEVIVStatValues()[buf.readByte()];
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.type.ordinal() - 1);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PixelmonEntity pixelmon;
        ServerPlayerEntity player = context.getSender();
        Entity entity = player.field_70170_p.func_73045_a(this.entityId);
        ItemStack hand = player.func_184586_b(Hand.MAIN_HAND);
        if (entity instanceof PixelmonEntity && hand.func_77973_b() == PixelmonItems.silver_bottle_cap && (pixelmon = (PixelmonEntity)entity).getPokemon().getOwnerPlayer() == player && BottlecapItem.onSilverSelection(player, pixelmon.getPokemon(), this.type) && !player.func_184812_l_()) {
            hand.func_190918_g(1);
        }
    }
}

