/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PlayerExtrasPacket
extends AbstractPixelmonPacket {
    private int slot;

    public PlayerExtrasPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    private PlayerExtrasPacket(int slot) {
        super(PacketDirection.PLAY_SERVER, true);
        this.slot = slot;
    }

    public static PlayerExtrasPacket getSetTexturePacket(int slot) {
        return new PlayerExtrasPacket(slot);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.slot);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.slot = buf.readByte();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.get(this.slot - 1);
        if (pokemon != null) {
            PixelExtrasData data = PixelExtrasStorage.getData(player.func_110124_au());
            if (pokemon.isPalette("online")) {
                pokemon.setPalette("none");
            } else if (data.canSeeTexture(pokemon.getSpecies())) {
                pokemon.setPalette("online");
            }
        }
    }
}

