/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class PlayParticleSystemPacket
extends AbstractPixelmonPacket {
    private ParticleSystems system;
    private double x;
    private double y;
    private double z;
    private ResourceLocation dimensionLocation;
    private float scale;
    private boolean shiny;
    private double[] args;

    public PlayParticleSystemPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public PlayParticleSystemPacket(ParticleSystems system, double x, double y, double z, World world, float scale, boolean shiny, double ... args) {
        super(PacketDirection.PLAY_CLIENT);
        this.system = system;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimensionLocation = world.func_234923_W_().func_240901_a_();
        this.scale = scale;
        this.shiny = shiny;
        this.args = args;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.system = ParticleSystems.values()[buf.readInt()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.dimensionLocation = buf.func_192575_l();
        this.scale = buf.readFloat();
        this.shiny = buf.readBoolean();
        this.args = new double[buf.readInt()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = buf.readDouble();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.system.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.func_192572_a(this.dimensionLocation);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.shiny);
        buf.writeInt(this.args.length);
        for (double arg : this.args) {
            buf.writeDouble(arg);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        if (Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_().equals((Object)this.dimensionLocation)) {
            this.system.getSystem().execute(Minecraft.func_71410_x(), (World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z, this.scale, this.shiny, this.args);
        }
    }
}

