/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.config.GeneralConfig;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockReveal;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class IlluminatePositionsPacket
extends AbstractPixelmonPacket {
    private RegistryKey<World> dimension;
    private int durationTicks;
    private Map<BlockPos, GeneralConfig.OreColor> locationColors = new HashMap<BlockPos, GeneralConfig.OreColor>();

    public IlluminatePositionsPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public IlluminatePositionsPacket(World world, int durationTicks, HashMap<BlockPos, GeneralConfig.OreColor> locationColors) {
        super(PacketDirection.PLAY_CLIENT);
        this.dimension = world.func_234923_W_();
        this.durationTicks = durationTicks;
        this.locationColors = locationColors;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.dimension = DimensionHelper.getDimension(buf.func_192575_l());
        this.durationTicks = buf.readUnsignedShort();
        int locationCount = buf.readUnsignedShort();
        for (int i = 0; i < locationCount; ++i) {
            BlockPos pos = buf.func_179259_c();
            String blockId = buf.func_218666_n();
            int color = buf.readInt();
            int pattern = buf.readInt();
            this.locationColors.put(pos, new GeneralConfig.OreColor(blockId, color, pattern));
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.dimension.func_240901_a_());
        buf.writeShort(this.durationTicks);
        buf.writeShort(this.locationColors.size());
        for (Map.Entry<BlockPos, GeneralConfig.OreColor> entry : this.locationColors.entrySet()) {
            buf.func_179255_a(entry.getKey());
            buf.func_180714_a(entry.getValue().getBlockId());
            buf.writeInt(entry.getValue().getColor());
            buf.writeInt(entry.getValue().getPattern());
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        for (Map.Entry<BlockPos, GeneralConfig.OreColor> entry : this.locationColors.entrySet()) {
            BlockRevealRenderer.revealedBlocks.add(new BlockReveal(this.dimension, this.durationTicks, entry.getKey(), entry.getValue().getColor(), entry.getValue().getPattern()));
        }
    }
}

