/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class SetTrainerData {
    public String name = "";
    public String greeting = "";
    public String win = "";
    public String lose = "";
    public ItemStack[] winnings;
    public int id = 0;
    public int winMoney = 10;
    public BattleRules rules;

    public SetTrainerData() {
    }

    public SetTrainerData(String name, String greeting, String win, String lose, int winMoney, ItemStack[] winnings) {
        this(name, greeting, win, lose, winMoney, winnings, null);
    }

    public SetTrainerData(String name, String greeting, String win, String lose, int winMoney, ItemStack[] winnings, BattleRules rules) {
        this.name = name;
        if (greeting.length() > Short.MAX_VALUE) {
            greeting = greeting.substring(0, Short.MAX_VALUE);
        }
        if (win.length() > Short.MAX_VALUE) {
            win = win.substring(0, Short.MAX_VALUE);
        }
        if (lose.length() > Short.MAX_VALUE) {
            lose = lose.substring(0, Short.MAX_VALUE);
        }
        this.greeting = greeting;
        this.win = win;
        this.lose = lose;
        this.winnings = winnings;
        this.winMoney = winMoney;
        this.rules = rules;
    }

    public SetTrainerData(NPCTrainer trainer, String localization) {
        this(trainer.getName(localization), trainer.getGreeting(localization), trainer.getWinMessage(localization), trainer.getLoseMessage(localization), trainer.getWinMoney(), trainer.getWinnings(), trainer.battleRules);
    }

    public void encodeInto(PacketBuffer buffer) {
        buffer.writeInt(this.id);
        buffer.func_180714_a(this.name);
        buffer.func_180714_a(this.greeting);
        buffer.func_180714_a(this.win);
        buffer.func_180714_a(this.lose);
        buffer.writeInt(this.winnings.length);
        for (int i = 0; i < this.winnings.length; ++i) {
            buffer.func_150788_a(this.winnings[i]);
        }
        buffer.writeInt(this.winMoney);
        if (this.rules == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.rules.encodeInto(buffer);
        }
    }

    public void decodeInto(PacketBuffer buffer) {
        this.id = buffer.readInt();
        this.name = buffer.func_218666_n();
        this.greeting = buffer.func_218666_n();
        this.win = buffer.func_218666_n();
        this.lose = buffer.func_218666_n();
        this.winnings = new ItemStack[buffer.readInt()];
        for (int i = 0; i < this.winnings.length; ++i) {
            this.winnings[i] = buffer.func_150791_c();
        }
        this.winMoney = buffer.readInt();
        if (buffer.readBoolean()) {
            this.rules = new BattleRules();
            this.rules.decodeInto(buffer);
        }
    }
}

