/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex.RequestSpawnDataPacket;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ClientPlayerPokedex
extends PlayerPokedex {
    Map<Integer, List<PlayerPokedex.PokedexSpawnData>> data = Maps.newHashMap();
    Map<Pair<Integer, String>, Map<Integer, List>> movesets = Maps.newHashMap();

    public void update(Map<Integer, PokedexRegistrationStatus> seenMap, Table<Integer, Short, Short> data2) {
        this.setSeenMap(seenMap);
        this.formDex = data2;
    }

    public void update(int npn, List<PlayerPokedex.PokedexSpawnData> spawnData) {
        this.data.put(npn, spawnData);
    }

    public void update(Species species, String form, Map<Integer, List> moveset) {
        this.movesets.put((Pair<Integer, String>)Pair.of((Object)species.getDex(), (Object)form), moveset);
    }

    public List<PlayerPokedex.PokedexSpawnData> getSpawnData(int npn) {
        List pokedexSpawnData = this.data.computeIfAbsent(npn, ___ -> Lists.newArrayList());
        if (pokedexSpawnData.isEmpty()) {
            NetworkHelper.sendToServer(new RequestSpawnDataPacket(npn));
        }
        return pokedexSpawnData;
    }
}

