/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityRenderer<T extends TileEntity>
extends net.minecraft.client.renderer.tileentity.TileEntityRenderer<T> {
    public static boolean profileTileEntityRender = false;
    boolean blend = false;
    boolean disableCulling = false;
    boolean disableLighting = false;
    boolean flip = true;
    float scale = 0.0f;
    float yOffset = 0.0f;
    int correctionAngles = 0;
    boolean doProcessing = true;

    public TileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public final void func_225616_a_(T te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (this.doProcessing) {
            int rotateDegrees = this.getRotation(state);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, (double)this.yOffset, 0.5);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(rotateDegrees + this.correctionAngles, 0.0f, 1.0f, 0.0f));
            if (this.flip) {
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            }
            if (this.scale != 0.0f) {
                matrix.func_227862_a_(this.scale, this.scale, this.scale);
            }
        }
        this.render(te, state, te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), partialTicks, matrix, buffer, combinedLight, combinedOverlay);
        if (this.doProcessing) {
            matrix.func_227865_b_();
        }
    }

    public abstract void render(T var1, BlockState var2, double var3, double var5, double var7, float var9, MatrixStack var10, IRenderTypeBuffer var11, int var12, int var13);

    protected int getRotation(BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof MultiBlock || block instanceof GenericRotatableModelBlock) {
            Direction facing;
            Direction direction = facing = block instanceof MultiBlock ? (Direction)state.func_177229_b((Property)MultiBlock.FACING) : (Direction)state.func_177229_b((Property)GenericRotatableModelBlock.FACING);
            if (facing == Direction.EAST) {
                return 270;
            }
            if (facing == Direction.NORTH) {
                return 0;
            }
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
        }
        return 0;
    }

    public boolean hasProperty(BlockState state, Property<?> property) {
        return state.func_235904_r_().contains(property);
    }

    @Deprecated
    public void bindTexture(ResourceLocation texture) {
        Pixelmon.LOGGER.error("bindTexture call! Can't do this anymore! " + texture);
    }

    public IVertexBuilder bindModelBuffer(IRenderTypeBuffer buffer, Model model, ResourceLocation texture) {
        return buffer.getBuffer(model.func_228282_a_(texture));
    }

    public void renderModel(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderModel(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderModel(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        if (model instanceof GenericSmdModel) {
            ((GenericSmdModel)model).getModel().animate();
        }
        model.func_225598_a_(matrix, buffer.getBuffer(model.func_228282_a_(texture)), light, overlay, r, g, b, a);
    }

    public IVertexBuilder bindSMDBuffer(IRenderTypeBuffer buffer, ResourceLocation texture) {
        return buffer.getBuffer(PixelmonRendering.getSMDRenderType(texture));
    }

    public void renderSMD(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderSMD(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderSMD(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        if (model instanceof GenericSmdModel) {
            ((GenericSmdModel)model).getModel().animate();
        }
        model.func_225598_a_(matrix, this.bindSMDBuffer(buffer, texture), light, overlay, r, g, b, a);
    }

    public void renderTransparentSMD(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        if (model instanceof GenericSmdModel) {
            ((GenericSmdModel)model).getModel().animate();
        }
        if (model instanceof ValveStudioModel) {
            ((ValveStudioModel)model).animate();
        }
        model.func_225598_a_(matrix, buffer.getBuffer(PixelmonRendering.getSMDRenderTypeTransparent(texture)), light, overlay, r, g, b, a);
    }

    public IVertexBuilder bindOBJBuffer(IRenderTypeBuffer buffer, ResourceLocation texture) {
        return buffer.getBuffer(PixelmonRendering.getOBJRenderTypeUndelegated(texture));
    }

    public void renderOBJ(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay) {
        this.renderOBJ(matrix, buffer, model, texture, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderOBJ(MatrixStack matrix, IRenderTypeBuffer buffer, Model model, ResourceLocation texture, int light, int overlay, float r, float g, float b, float a) {
        model.func_225598_a_(matrix, this.bindOBJBuffer(buffer, texture), light, overlay, r, g, b, a);
    }
}

