/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.TradeMachineTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityTradeMachine
extends TileEntityRenderer<TradeMachineTileEntity> {
    private static final ResourceLocation bracket = ResourceLocationHelper.of("pixelmon", "textures/block/trademachine/bracket.png");
    private static final ResourceLocation placeholder = ResourceLocationHelper.of("pixelmon", "textures/block/placeholder.png");
    private static final GenericModelHolder<GenericSmdModel> arrows = new GenericModelHolder("blocks/trade_machine/arrows.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke1Poke = new GenericModelHolder("blocks/trade_machine/poke1poke.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke1Bracket = new GenericModelHolder("blocks/trade_machine/poke1bracket.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke1Player = new GenericModelHolder("blocks/trade_machine/poke1player.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke1HeldItem = new GenericModelHolder("blocks/trade_machine/poke1helditem.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke1Ready = new GenericModelHolder("blocks/trade_machine/poke1ready.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke2Poke = new GenericModelHolder("blocks/trade_machine/poke2poke.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke2Bracket = new GenericModelHolder("blocks/trade_machine/poke2bracket.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke2Player = new GenericModelHolder("blocks/trade_machine/poke2player.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke2HeldItem = new GenericModelHolder("blocks/trade_machine/poke2helditem.pqc");
    private static final GenericModelHolder<GenericSmdModel> poke2Ready = new GenericModelHolder("blocks/trade_machine/poke2ready.pqc");

    public RenderTileEntityTradeMachine(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
    }

    @Override
    public void render(TradeMachineTileEntity tradeMachine, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IVertexBuilder vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(bracket));
        ((GenericSmdModel)((Object)arrows.getModel())).getModel().animate();
        arrows.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
        poke1Bracket.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
        poke2Bracket.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
        SkinManager skinManager = Minecraft.func_71410_x().func_152342_ad();
        if (tradeMachine.user1 != null && !tradeMachine.user1.isEmpty() || tradeMachine.user2 != null && !tradeMachine.user2.isEmpty()) {
            String[] users = new String[]{tradeMachine.user1, tradeMachine.user2};
            for (int i = 0; i < 2; ++i) {
                if (users[i] != null && !users[i].isEmpty()) {
                    String username = users[i];
                    PlayerEntity player = tradeMachine.func_145831_w().func_217369_A().stream().filter(p -> p.func_200200_C_().getString().equalsIgnoreCase(username)).findFirst().orElse(null);
                    if (player != null) {
                        ResourceLocation resourcelocation;
                        Map map = skinManager.func_152788_a(player.func_146103_bH());
                        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            resourcelocation = skinManager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        } else {
                            UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
                            resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                        }
                        vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(resourcelocation));
                    } else {
                        vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                    }
                    (i == 0 ? poke1Player : poke2Player).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
                } else {
                    vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                }
                (i == 0 ? poke1Player : poke2Player).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            }
            CompoundNBT[] pokemon = new CompoundNBT[]{tradeMachine.poke1, tradeMachine.poke2};
            for (int i = 0; i < 2; ++i) {
                if (pokemon[i] == null) continue;
                String name = pokemon[i].func_74779_i("Name");
                boolean isEgg = pokemon[i].func_74767_n("isEgg");
                int eggCycles = pokemon[i].func_74762_e("eggCycles");
                String form = pokemon[i].func_74779_i("Variant");
                String palette = pokemon[i].func_74779_i("palette");
                String pokeball = pokemon[i].func_74779_i("CaughtBall");
                int number = Pokedex.nameToID(name);
                PokeBall pokeballs = PokeBallRegistry.getPokeBall(pokeball).getValueUnsafe();
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(pokeballs.getModelTexture()));
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                int rotation = this.getRotation(state);
                if (i == 0) {
                    if (rotation == 270) {
                        matrix.func_227861_a_(x + 0.5, y + 0.93, z + 0.4);
                    } else if (rotation == 180) {
                        matrix.func_227861_a_(x + 0.6, y + 0.93, z + 0.5);
                    } else if (rotation == 90) {
                        matrix.func_227861_a_(x + 0.5, y + 0.93, z + 0.6);
                    } else {
                        matrix.func_227861_a_(x + 0.4, y + 0.93, z + 0.5);
                    }
                } else if (rotation == 270) {
                    matrix.func_227861_a_(x + 0.5, y + 0.93, z + 2.2 + 0.4);
                } else if (rotation == 180) {
                    matrix.func_227861_a_(x - 2.2 + 0.6, y + 0.93, z + 0.5);
                } else if (rotation == 90) {
                    matrix.func_227861_a_(x + 0.5, y + 0.93, z - 2.2 + 0.6);
                } else {
                    matrix.func_227861_a_(x + 2.2 + 0.4, y + 0.93, z + 0.5);
                }
                matrix.func_227863_a_(QuaternionHelper.fromEuler(this.getRotation(state), 0.0f, 1.0f, 0.0f));
                GenericModelHolder<ModelPokeballs> model = pokeballs.getModelHolder();
                ((ModelPokeballs)((Object)model.getModel())).theModel.setAnimation(AnimationType.IDLE);
                ((ModelPokeballs)((Object)model.getModel())).theModel.animate();
                matrix.func_227862_a_(0.0022f, 0.0022f, 0.0022f);
                model.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
                matrix.func_227865_b_();
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)((float)x + 0.5f), (double)((float)y + this.yOffset), (double)((float)z + 0.5f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(this.getRotation(state) + this.correctionAngles, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                if (pokemon[i].func_74764_b("HeldItemStack")) {
                    ItemStack heldItem = ItemStack.func_199557_a((CompoundNBT)pokemon[i].func_74775_l("HeldItemStack"));
                    if (heldItem.func_190926_b()) {
                        vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                        (i == 0 ? poke1HeldItem : poke2HeldItem).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
                    } else {
                        vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(ResourceLocationHelper.of("pixelmon", "textures/helditem.png")));
                        (i == 0 ? poke1HeldItem : poke2HeldItem).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
                    }
                } else {
                    vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                    (i == 0 ? poke1HeldItem : poke2HeldItem).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
                }
                String spriteTextureLocation = this.getSpriteFromID(number, name, palette, isEgg, eggCycles, form);
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(ResourceLocationHelper.of(spriteTextureLocation)));
                (i == 0 ? poke1Poke : poke2Poke).render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            }
            if (tradeMachine.ready1) {
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(ResourceLocationHelper.of("pixelmon", "textures/block/trademachine/ready.png")));
                ((GenericSmdModel)((Object)poke1Ready.getModel())).getModel().animate();
                poke1Ready.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            } else {
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                ((GenericSmdModel)((Object)poke1Ready.getModel())).getModel().animate();
                poke1Ready.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            }
            if (tradeMachine.ready2) {
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(ResourceLocationHelper.of("pixelmon", "textures/block/trademachine/ready.png")));
                ((GenericSmdModel)((Object)poke2Ready.getModel())).getModel().animate();
                poke2Ready.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            } else {
                vertexBuffer = buffer.getBuffer(PixelmonRendering.getSMDRenderTypeUndelegated(placeholder));
                ((GenericSmdModel)((Object)poke2Ready.getModel())).getModel().animate();
                poke2Ready.render(matrix, vertexBuffer, combinedLight, combinedOverlay);
            }
        }
    }

    private String getSpriteFromID(int nationalPokedexNumber, String pokemonName, String palette, boolean isEgg, int eggCycles, String form) {
        Species pokemon;
        String basePath = "";
        if (isEgg) {
            basePath = "textures/sprites/eggs/";
        }
        if (isEgg) {
            String eggType = "egg";
            if (nationalPokedexNumber == 175) {
                eggType = "togepi";
            } else if (nationalPokedexNumber == 490) {
                eggType = "manaphy";
            }
            if (eggCycles > 10) {
                return basePath + eggType + "1.png";
            }
            if (eggCycles > 5) {
                return basePath + eggType + "2.png";
            }
            return basePath + eggType + "3.png";
        }
        RegistryValue<Species> optional = PixelmonSpecies.fromName(pokemonName);
        if (optional.isInitialized() && (pokemon = optional.getValueUnsafe()) != null) {
            GenderProperties genderProperties;
            PaletteProperties paletteProperties;
            Stats pokemonForm = pokemon.getForm(form);
            if (pokemonForm == null) {
                pokemonForm = pokemon.getDefaultForm();
            }
            if ((paletteProperties = (genderProperties = pokemonForm.getDefaultGenderProperties()).getPalette(palette)) == null) {
                paletteProperties = genderProperties.getDefaultPalette();
            }
            return basePath + paletteProperties.getSprite();
        }
        return basePath + String.format("%03d", nationalPokedexNumber) + ".png";
    }
}

