/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class LayerWings
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final ResourceLocation WINGS_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/wings/articuno_wings");
    public static final ResourceLocation VALENTINES_WINGS_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/wings/heart_wings");
    private final PlayerRenderer renderer;

    public LayerWings(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras = PlayerExtraDataStore.get((PlayerEntity)player);
        if (!extras.isReady() || !extras.isEnabled(PixelExtrasData.Category.WINGS) || extras.getWingType() == PixelExtrasData.WingType.NONE || player.func_82150_aj()) {
            return;
        }
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
        matrix.func_227860_a_();
        body.func_228307_a_(matrix);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.func_227861_a_(-0.5, -1.5, -0.5);
        IBakedModel model = null;
        if (extras.getWingType() == PixelExtrasData.WingType.CHRISTMAS_ARTICUNO) {
            model = Minecraft.func_71410_x().func_209506_al().getModel(WINGS_MODEL);
        } else if (extras.getWingType() == PixelExtrasData.WingType.VALENTINES_HEART) {
            model = Minecraft.func_71410_x().func_209506_al().getModel(VALENTINES_WINGS_MODEL);
        }
        if (model != null) {
            PixelmonRendering.renderQuadList(matrix.func_227866_c_(), buffer.getBuffer(RenderType.func_228643_e_()), 1.0f, 1.0f, 1.0f, model.getQuads(null, null, RandomHelper.getRandom(), (IModelData)EmptyModelData.INSTANCE), packedLight, packedOverlay);
        }
        matrix.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }
}

