/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.BadgeCaseItem;
import com.pixelmonmod.pixelmon.items.BadgeItem;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.RelicCrownItem;
import com.pixelmonmod.pixelmon.items.SpriteItem;
import com.pixelmonmod.pixelmon.items.SymbolItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class LayerEquippables
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private static final double[][] BC_POSITIONS = new double[][]{{0.08, 0.13}, {0.15, 0.13}, {0.08, 0.2}, {0.15, 0.2}, {0.08, 0.27}, {0.15, 0.27}, {0.08, 0.34}, {0.15, 0.34}};
    private final PlayerRenderer renderer;
    private final Map<String, GenericModelHolder<GenericSmdModel>> equippableModels = new HashMap<String, GenericModelHolder<GenericSmdModel>>();
    private static PixelmonEntity pokemon;

    public LayerEquippables(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
        this.equippableModels.put("safety_goggles", new GenericModelHolder("playeritems/equippables/safety_goggles.pqc"));
    }

    public static boolean hasEquippables(AbstractClientPlayerEntity player) {
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            return true;
        }
        return false;
    }

    public static PixelmonEntity getPokemon(World world, Optional<Pokemon> newPoke) {
        if (pokemon != null && newPoke.isPresent() && Objects.equals(newPoke.get().getSpecies(), pokemon.getPokemon().getSpecies()) && Objects.equals(newPoke.get().getForm(), pokemon.getPokemon().getForm()) && Objects.equals(newPoke.get().getPalette(), pokemon.getPokemon().getPalette()) && Objects.equals(newPoke.get().getGender(), pokemon.getPokemon().getGender())) {
            return pokemon;
        }
        if (pokemon == null || newPoke.isPresent()) {
            pokemon = new PixelmonEntity(world, newPoke.get());
            pokemon.setDisableNametag(true);
            pokemon.setAnimation(AnimationType.IDLE);
        }
        return pokemon;
    }

    public static PixelmonEntity getPokemon() {
        return pokemon;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
        ModelRenderer body = ((PlayerModel)this.renderer.func_217764_d()).field_78115_e;
        ModelRenderer head = ((PlayerModel)this.renderer.func_217764_d()).field_78116_c;
        HashSet equippables = Sets.newHashSet();
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            equippables.add((IEquippable)stack.func_77973_b());
        }
        if (equippables.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        for (IEquippable equippable : equippables) {
            ItemStack stack;
            matrix.func_227860_a_();
            Item item = equippable.getEquippableItem();
            if (item == PixelmonItems.safety_goggles) {
                GenericModelHolder<GenericSmdModel> model = this.equippableModels.get(equippable.getEquippableModelKey());
                IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(equippable.getEquippableTexture()));
                head.func_228307_a_(matrix);
                matrix.func_227861_a_(0.0, (double)1.54f, 0.0);
                matrix.func_227861_a_(0.0, (double)-1.82f, (double)-0.15f);
                matrix.func_227862_a_(0.62f, 0.62f, 0.62f);
                ((GenericSmdModel)((Object)model.getModel())).getModel().animate();
                model.render(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (item instanceof BadgeItem || item instanceof SymbolItem) {
                body.func_228307_a_(matrix);
                matrix.func_227861_a_(0.1, 0.2, -0.11);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                float s = 0.15f;
                matrix.func_227862_a_(s, s, 1.0f);
                Minecraft.func_71410_x().func_175599_af().func_229109_a_((LivingEntity)player, new ItemStack((IItemProvider)equippable.getEquippableItem()), ItemCameraTransforms.TransformType.NONE, true, matrix, buffer, player.field_70170_p, packedLight, packedOverlay);
            } else if (item instanceof BadgeCaseItem) {
                BadgeCaseItem.BadgeCase badgeCase;
                stack = player.func_184582_a(EquipmentSlotType.CHEST);
                if (stack.func_77942_o() && (badgeCase = BadgeCaseItem.BadgeCase.readFromItemStack(stack)) != null) {
                    int i = 0;
                    body.func_228307_a_(matrix);
                    for (ItemStack badge : badgeCase.badges) {
                        if (i < 8) {
                            matrix.func_227860_a_();
                            double[] pos = BC_POSITIONS[i];
                            matrix.func_227861_a_(pos[0], pos[1], -0.11);
                            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                            matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                            float s = 0.075f;
                            matrix.func_227862_a_(s, s, 1.0f);
                            Minecraft.func_71410_x().func_175599_af().func_229109_a_((LivingEntity)player, badge, ItemCameraTransforms.TransformType.NONE, true, matrix, buffer, player.field_70170_p, packedLight, packedOverlay);
                            matrix.func_227865_b_();
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (item instanceof SpriteItem) {
                stack = player.func_184582_a(EquipmentSlotType.HEAD);
                if (stack.func_77942_o() && stack.func_77973_b() instanceof SpriteItem && stack.func_77978_p().func_74764_b("ndex")) {
                    Optional<Pokemon> spriteItem = SpriteItemHelper.getPokemon(stack);
                    if (!spriteItem.isPresent()) {
                        return;
                    }
                    head.func_228307_a_(matrix);
                    matrix.func_227861_a_(0.0, (double)1.54f, 0.0);
                    matrix.func_227861_a_(0.0, (double)-2.02f, (double)-0.15f);
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                    PixelmonRendering.renderEntity(matrix, LayerEquippables.getPokemon(player.field_70170_p, spriteItem), false, partialTicks);
                }
            } else if (item instanceof RelicCrownItem) {
                matrix.func_227860_a_();
                head.func_228307_a_(matrix);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                matrix.func_227861_a_(-0.5, 0.5, -0.5);
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                BlockState state = PixelmonBlocks.relic_crown.func_176223_P();
                blockrendererdispatcher.func_175019_b().renderModel(matrix.func_227866_c_(), buffer.getBuffer(RenderType.func_228639_c_()), state, blockrendererdispatcher.func_184389_a(state), 1.0f, 1.0f, 1.0f, packedLight, LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f), (IModelData)EmptyModelData.INSTANCE);
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
        }
        mc.func_213239_aq().func_76319_b();
    }
}

