/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.layers.npc.LayerMegaItemsNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NPCRenderer
extends LivingRenderer<NPCEntity, PlayerModel<NPCEntity>> {
    private static final ResourceLocation BUG_CATCHER = ResourceLocationHelper.ofTexture("pixelmon", "textures/steve/bugcatcher3.png");
    private final int defaultNameRenderDistance = 8;
    private final int defaultBossNameRenderDistanceExtension = 8;
    private final int configNameRenderMultiplier = Math.max(1, Math.min(PixelmonConfigProxy.getGraphics().getNamePlateRange(), 3));
    private final int nameRenderDistanceNormal;
    private final int nameRenderDistanceBoss;

    public NPCRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new PlayerModel(0.0f, false), 0.5f);
        ((Object)((Object)this)).getClass();
        this.nameRenderDistanceNormal = 8 * this.configNameRenderMultiplier;
        ((Object)((Object)this)).getClass();
        this.nameRenderDistanceBoss = this.nameRenderDistanceNormal + 8;
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a(new LayerMegaItemsNPC(this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
    }

    public void render(NPCEntity npc, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        if (this.field_77045_g == null) {
            return;
        }
        float distance = 20.0f;
        if (Minecraft.func_71410_x().field_175622_Z != null) {
            distance = npc.func_70032_d(Minecraft.func_71410_x().field_175622_Z);
        }
        float renderDistance = this.nameRenderDistanceNormal;
        if (npc.getBossTier() != null) {
            float f = renderDistance = npc.getBossTier().isBoss() ? (float)this.nameRenderDistanceBoss : (float)this.nameRenderDistanceNormal;
        }
        if (distance <= renderDistance) {
            this.drawNameTag(npc, entityYaw, partialTicks, matrix, buffer, packedLight);
        }
        this.setModelVisibilities(npc);
        super.func_225623_a_((LivingEntity)npc, entityYaw, partialTicks, matrix, buffer, packedLight);
    }

    public Vector3d getRenderOffset(NPCEntity entityIn, float partialTicks) {
        return entityIn.func_213453_ef() ? new Vector3d(0.0, -0.125, 0.0) : super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    protected boolean shouldShowName(NPCEntity npc) {
        return false;
    }

    public void drawNameTag(NPCEntity npc, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        if (Minecraft.func_71382_s()) {
            String displayText = npc.getDisplayText();
            String subtitleText = npc.getSubTitleText();
            if (!displayText.equals("")) {
                this.renderLivingLabel(npc, displayText, subtitleText, entityYaw, partialTicks, matrix, buffer, packedLight);
            }
        }
    }

    protected void renderLivingLabel(NPCEntity npc, String displayText, String subtitleText, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        FontRenderer fontRenderer = this.func_76983_a();
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        matrix.func_227860_a_();
        if (npc.getModelScale().func_195900_b() < 1.0f) {
            matrix.func_227861_a_(0.0, (double)2.1f, 0.0);
        } else {
            matrix.func_227861_a_(0.0, 2.5, 0.0);
        }
        matrix.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrix.func_227862_a_(-var14, -var14, var14);
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        if (npc instanceof NPCTrainer && npc.getBossTier().isBoss()) {
            BossTier bossTier = npc.getBossTier();
            String bossTag = I18n.func_135052_a((String)"gui.boss.text", (Object[])new Object[0]);
            String bossMode = I18n.func_188566_a((String)bossTier.getName()) ? I18n.func_135052_a((String)bossTier.getName(), (Object[])new Object[0]) : bossTier.getName();
            int bossTagWidth = fontRenderer.func_78256_a(bossMode);
            int bossTagpos = bossTagWidth / 2 * -1;
            matrix.func_227860_a_();
            matrix.func_227861_a_(-2.5 + (double)bossTagpos, -5.5, 0.0);
            matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
            fontRenderer.func_243247_a((ITextComponent)new StringTextComponent(bossTag), 0.0f, 0.0f, -1, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLight);
            matrix.func_227865_b_();
            fontRenderer.func_243247_a((ITextComponent)new StringTextComponent(bossMode), (float)bossTagpos, 0.0f, bossTier.getColor().getRGB(), false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLight);
        } else {
            if (subtitleText != null) {
                int displayTextWidth = fontRenderer.func_78256_a(displayText);
                int displayTextPos = displayTextWidth / 2 * -1;
                matrix.func_227860_a_();
                matrix.func_227861_a_(-2.5 + (double)displayTextPos, -5.5, 0.0);
                matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
                fontRenderer.func_243247_a((ITextComponent)new StringTextComponent(subtitleText), 0.0f, 0.0f, -1, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLight);
                matrix.func_227865_b_();
            }
            fontRenderer.func_243247_a((ITextComponent)new StringTextComponent(displayText), (float)(-fontRenderer.func_78256_a(displayText)) / 2.0f, 0.0f, -1, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLight);
        }
        matrix.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(NPCEntity entity) {
        ResourceLocation resourceLocation = ResourceLocationHelper.of(entity.getTexture());
        if (resourceLocation != null) {
            return resourceLocation;
        }
        resourceLocation = ResourceLocationHelper.of(entity.getTexture().replace(";", ""));
        if (resourceLocation != null) {
            return resourceLocation;
        }
        return BUG_CATCHER;
    }

    protected void scale(NPCEntity npc, MatrixStack matrix, float partialTickTime) {
        Vector3f scale = npc.getModelScale();
        matrix.func_227862_a_(scale.func_195899_a(), scale.func_195900_b(), scale.func_195902_c());
        super.func_225620_a_((LivingEntity)npc, matrix, partialTickTime);
    }

    private void setModelVisibilities(NPCEntity npc) {
        PlayerModel model = (PlayerModel)this.func_217764_d();
        if (npc.func_175149_v()) {
            model.func_178719_a(false);
            model.field_78116_c.field_78806_j = true;
            model.field_178720_f.field_78806_j = true;
        } else {
            model.func_178719_a(true);
            model.field_178720_f.field_78806_j = true;
            model.field_178730_v.field_78806_j = true;
            model.field_178733_c.field_78806_j = true;
            model.field_178731_d.field_78806_j = true;
            model.field_178734_a.field_78806_j = true;
            model.field_178732_b.field_78806_j = true;
            model.field_228270_o_ = npc.func_213453_ef();
            BipedModel.ArmPose bipedmodel$armpose = NPCRenderer.getArmPose(npc, Hand.MAIN_HAND);
            BipedModel.ArmPose bipedmodel$armpose1 = NPCRenderer.getArmPose(npc, Hand.OFF_HAND);
            if (bipedmodel$armpose.func_241657_a_()) {
                BipedModel.ArmPose armPose = bipedmodel$armpose1 = npc.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (npc.func_184591_cq() == HandSide.RIGHT) {
                model.field_187076_m = bipedmodel$armpose;
                model.field_187075_l = bipedmodel$armpose1;
            } else {
                model.field_187076_m = bipedmodel$armpose1;
                model.field_187075_l = bipedmodel$armpose;
            }
        }
    }

    private static BipedModel.ArmPose getArmPose(NPCEntity npc, Hand hand) {
        ItemStack itemstack = npc.func_184586_b(hand);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (npc.func_184600_cs() == hand && npc.func_184605_cv() > 0) {
            UseAction useaction = itemstack.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && hand == npc.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!npc.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    public void renderRightArm(MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, NPCEntity npc) {
        this.renderItem(matrix, buffer, combinedLight, npc, ((PlayerModel)this.field_77045_g).field_178723_h, ((PlayerModel)this.field_77045_g).field_178732_b);
    }

    public void renderLeftArm(MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, NPCEntity npc) {
        this.renderItem(matrix, buffer, combinedLight, npc, ((PlayerModel)this.field_77045_g).field_178724_i, ((PlayerModel)this.field_77045_g).field_178734_a);
    }

    private void renderItem(MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, NPCEntity npc, ModelRenderer rendererArm, ModelRenderer rendererArmwear) {
        PlayerModel model = (PlayerModel)this.func_217764_d();
        this.setModelVisibilities(npc);
        model.field_217112_c = 0.0f;
        model.field_228270_o_ = false;
        model.field_205061_a = 0.0f;
        model.func_225597_a_((LivingEntity)npc, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArm.field_78795_f = 0.0f;
        rendererArm.func_228308_a_(matrix, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getTextureLocation(npc))), combinedLightIn, OverlayTexture.field_229196_a_);
        rendererArmwear.field_78795_f = 0.0f;
        rendererArmwear.func_228308_a_(matrix, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(npc))), combinedLightIn, OverlayTexture.field_229196_a_);
    }

    protected void setupRotations(NPCEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
            Vector3d vector3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

