/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.blockReveal;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockReveal;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockRevealRenderer {
    public static CopyOnWriteArrayList<BlockReveal> revealedBlocks = new CopyOnWriteArrayList();
    private boolean increasing = true;
    private short ticker = 0;
    private long lastTime = -1L;
    private int tickDecrease = 0;

    public void doRender(MatrixStack matrix, IRenderTypeBuffer tesselator) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            revealedBlocks.clear();
            return;
        }
        if (this.increasing) {
            this.ticker = (short)(this.ticker + 1);
            if (this.ticker >= 100) {
                this.increasing = false;
            }
        } else {
            this.ticker = (short)(this.ticker - 1);
            if (this.ticker <= 0) {
                this.increasing = true;
            }
        }
        if (this.lastTime != -1L) {
            int ticks = (int)(mc.field_71441_e.func_82737_E() - this.lastTime);
            if (ticks != 0) {
                this.tickDecrease = ticks;
                this.lastTime = mc.field_71441_e.func_82737_E();
            }
        } else {
            this.lastTime = mc.field_71441_e.func_82737_E();
        }
        ClientPlayerEntity viewpoint = mc.func_175606_aa() == null ? mc.field_71439_g : mc.func_175606_aa();
        float tx = (float)(viewpoint.field_70169_q + (viewpoint.func_226277_ct_() - viewpoint.field_70169_q) * (double)mc.func_184121_ak());
        float ty = (float)(viewpoint.field_70167_r + (viewpoint.func_226278_cu_() - viewpoint.field_70167_r) * (double)mc.func_184121_ak());
        float tz = (float)(viewpoint.field_70166_s + (viewpoint.func_226281_cx_() - viewpoint.field_70166_s) * (double)mc.func_184121_ak());
        matrix.func_227861_a_((double)(-tx), (double)(-ty), (double)(-tz));
        matrix.func_227860_a_();
        if (revealedBlocks.size() > 0) {
            revealedBlocks.removeIf(blockReveal -> !this.render(matrix, tesselator, (BlockReveal)blockReveal));
        }
        matrix.func_227865_b_();
    }

    private boolean render(MatrixStack matrix, IRenderTypeBuffer tesselator, BlockReveal block) {
        Minecraft mc = Minecraft.func_71410_x();
        IVertexBuilder buffer = tesselator.getBuffer(PixelmonRendering.outline(RenderType.field_228491_A_));
        block.drawDown = true;
        block.drawUp = true;
        block.drawNorth = true;
        block.drawSouth = true;
        block.drawEast = true;
        block.drawWest = true;
        for (BlockReveal reveal : revealedBlocks) {
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.DOWN))) {
                block.drawDown = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.UP))) {
                block.drawUp = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.NORTH))) {
                block.drawNorth = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.SOUTH))) {
                block.drawSouth = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.EAST))) {
                block.drawEast = false;
            }
            if (!reveal.getPos().equals((Object)block.getPos().func_177972_a(Direction.WEST))) continue;
            block.drawWest = false;
        }
        if (block.getDimension() == mc.field_71441_e.func_234923_W_()) {
            int pattern = block.getPattern();
            boolean draw = true;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (block.getPattern() == 7) {
                if (WorldTime.getCurrent((World)mc.field_71441_e).contains(WorldTime.DAWN)) {
                    r = 0.54509807f;
                    g = 0.75686276f;
                    b = 0.7882353f;
                    pattern = 12;
                } else if (WorldTime.getCurrent((World)mc.field_71441_e).contains(WorldTime.DUSK)) {
                    r = 0.4627451f;
                    g = 0.44313726f;
                    b = 0.7411765f;
                    pattern = 13;
                } else {
                    draw = false;
                }
            } else {
                r = (float)block.getColor().getRed() / 255.0f;
                g = (float)block.getColor().getGreen() / 255.0f;
                b = (float)block.getColor().getBlue() / 255.0f;
            }
            if (draw) {
                this.patternProvider(matrix, buffer, block, pattern, r, g, b, 0.7f - 0.4f * ((float)this.ticker / 100.0f) - (block.getTicksRemaining() <= 30 ? 0.7f - 0.7f * ((float)block.getTicksRemaining() / 30.0f) : 0.0f));
            }
        }
        if (this.lastTime != -1L) {
            int ticks = (int)(mc.field_71441_e.func_82737_E() - this.lastTime);
            if (ticks != 0) {
                block.decreaseTicksRemaining(ticks);
                this.lastTime = mc.field_71441_e.func_82737_E();
            }
        } else {
            this.lastTime = mc.field_71441_e.func_82737_E();
        }
        block.decreaseTicksRemaining(this.tickDecrease);
        ((IRenderTypeBuffer.Impl)tesselator).func_228462_a_(PixelmonRendering.outline(RenderType.field_228491_A_));
        return block.getTicksRemaining() >= 0;
    }

    private void patternProvider(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, int pattern, float r, float g, float b, float a) {
        switch (pattern) {
            case 0: {
                this.pattern0(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 1: {
                this.pattern1(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 2: {
                this.pattern2(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 3: {
                this.pattern3(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 4: {
                this.pattern4(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 5: {
                this.pattern5(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 6: {
                this.pattern6(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 7: {
                this.pattern7(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 8: {
                this.pattern8(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 9: {
                this.pattern9(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 10: {
                this.pattern10(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 11: {
                this.pattern11(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 12: {
                this.pattern12(matrix, buffer, block, r, g, b, a);
                break;
            }
            case 13: {
                this.pattern13(matrix, buffer, block, r, g, b, a);
            }
        }
    }

    private void pattern0(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 4, 13, 5, 14, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 12, 9, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 13, 14, 14, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 10, 9, 12, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 8, 10, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 7, 11, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 11, 7, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 10, 8, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 1, 8, 3, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 4, 6, 5, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 3, 5, 2, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 5, 13, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 4, 14, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 3, 11, 2, r, g, b, a);
    }

    private void pattern1(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 8, 15, 6, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 14, 13, 12, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 12, 4, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 11, 6, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 8, 6, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 7, 10, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 15, 6, 13, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 5, 7, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 3, 1, 1, r, g, b, a);
    }

    private void pattern2(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 14, 14, 12, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 13, 7, 12, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 14, 2, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 13, 5, 12, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 11, 10, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 11, 5, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 10, 3, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 9, 1, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 8, 11, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 8, 9, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 7, 8, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 8, 7, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 15, 7, 13, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 4, 8, 2, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 6, 4, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 5, 2, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 4, 5, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 3, 4, 1, r, g, b, a);
    }

    private void pattern3(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 11, 2, 13, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 13, 3, 14, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 2, 8, 3, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 3, 9, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 4, 10, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 5, 10, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 6, 12, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 5, 13, 8, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 13, 6, 14, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 14, 7, 15, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 2, 4, 3, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 4, 4, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 4, 5, 5, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 6, 7, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 8, 8, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 8, 9, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 9, 10, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 10, 9, 11, 12, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 10, 12, 12, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 2, 8, 3, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 9, 4, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 4, 10, 6, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 11, 7, 14, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 12, 8, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 12, 9, 14, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 13, 10, 15, r, g, b, a);
    }

    private void pattern4(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 3, 2, 4, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 2, 3, 3, 4, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 13, 1, 14, 2, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 4, 13, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 9, 7, 11, 8, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 5, 6, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 4, 7, 7, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 5, 8, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 1, 7, 2, 8, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 8, 5, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 5, 9, 8, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 10, 12, 11, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 11, 9, 12, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 12, 8, 13, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 13, 9, 14, 12, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 1, 12, 3, 13, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 3, 11, 4, 14, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 4, 12, 5, 13, r, g, b, a);
    }

    private void pattern5(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, 5, 6, 12, 8, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 7, 8, 10, 10, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 8, 7, 9, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 10, 9, 11, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 6, 5, 11, 6, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 4, 10, 5, r, g, b, a);
        this.drawQuad(matrix, buffer, block, 8, 3, 9, 4, r, g, b, a);
    }

    private void pattern6(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 1, 8, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 2, 5, 1, 5, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 3, 4, 1, 7, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 4, 3, 6, 9, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 5, 12, 3, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 10, 4, 1, 6, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 11, 4, 1, 5, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 12, 5, 1, 4, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 13, 5, 1, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 13, 8, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 14, 5, 1, 1, r, g, b, a);
    }

    private void pattern7(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
    }

    private void pattern8(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 7, 3, 1, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 3, 2, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 10, 3, 1, 4, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 11, 4, 1, 6, r, g, b, a);
    }

    private void pattern9(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 3, 11, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 4, 11, 1, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 5, 10, 2, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 7, 9, 1, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 8, 1, 4, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 9, 10, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 9, 7, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 9, 5, 1, 1, r, g, b, a);
    }

    private void pattern10(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 5, 2, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 5, 4, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 6, 3, 3, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 9, 4, 3, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 7, 6, 4, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 7, 2, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 10, 8, 1, 1, r, g, b, a);
    }

    private void pattern11(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 11, 4, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 7, 5, 6, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 7, 4, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 10, 8, 2, 1, r, g, b, a);
    }

    private void pattern12(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 4, 5, 1, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 5, 4, 1, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 6, 4, 5, 4, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 3, 2, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 11, 4, 1, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 7, 8, 3, 1, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 9, 1, 1, r, g, b, a);
    }

    private void pattern13(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, float r, float g, float b, float a) {
        this.drawSizedQuad(matrix, buffer, block, 6, 8, 1, 2, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 7, 7, 1, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 8, 6, 2, 3, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 10, 3, 1, 5, r, g, b, a);
        this.drawSizedQuad(matrix, buffer, block, 11, 5, 1, 3, r, g, b, a);
    }

    private void drawSizedQuad(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, int x, int z, int w, int h, float r, float g, float b, float a) {
        this.drawQuad(matrix, buffer, block, x, z, x + w, z + h, r, g, b, a);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawQuad(MatrixStack matrix, IVertexBuilder buffer, BlockReveal block, int x1, int z1, int x2, int z2, float r, float g, float b, float a) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int side = 0;
        while (true) {
            block14: {
                if (side >= 6) {
                    return;
                }
                double yaw = 0.0;
                double pitch = 0.0;
                boolean inverse = false;
                switch (side) {
                    case 0: {
                        if (!(player.func_226278_cu_() + (double)player.func_70047_e() > (double)block.getPos().func_177956_o()) && block.drawDown) break;
                        break block14;
                    }
                    case 1: {
                        if (!(player.func_226278_cu_() + (double)player.func_70047_e() < (double)(block.getPos().func_177956_o() + 1)) && block.drawUp) {
                            pitch = Math.PI;
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (!(player.func_226281_cx_() < (double)(block.getPos().func_177952_p() + 1)) && block.drawSouth) {
                            pitch = 1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 3: {
                        if (!(player.func_226281_cx_() > (double)block.getPos().func_177952_p()) && block.drawNorth) {
                            yaw = Math.PI;
                            pitch = -1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 4: {
                        if (!(player.func_226277_ct_() > (double)block.getPos().func_177958_n()) && block.drawWest) {
                            inverse = true;
                            yaw = 1.5707963267948966;
                            pitch = 1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 5: {
                        if (player.func_226277_ct_() < (double)(block.getPos().func_177958_n() + 1) || !block.drawEast) break block14;
                        inverse = true;
                        yaw = -1.5707963267948966;
                        pitch = 1.5707963267948966;
                    }
                }
                this.rotatePointAndDraw(matrix, buffer, r, g, b, a, (float)block.getPos().func_177958_n() + (float)x1 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z1 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw(matrix, buffer, r, g, b, a, (float)block.getPos().func_177958_n() + (float)x2 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z1 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw(matrix, buffer, r, g, b, a, (float)block.getPos().func_177958_n() + (float)x2 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z2 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw(matrix, buffer, r, g, b, a, (float)block.getPos().func_177958_n() + (float)x1 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z2 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
            }
            ++side;
        }
    }

    private double[] rotatePoint(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch, boolean inverse) {
        if (inverse) {
            double ry = Math.sin(pitch) * (pz - cz) + Math.cos(pitch) * (py - cy) + cy;
            double rz = Math.cos(pitch) * (pz - cz) - Math.sin(pitch) * (py - cy) + cz;
            double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (rz - cz) + cx;
            rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (rz - cz) + cz;
            return new double[]{rx, ry, rz};
        }
        double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (pz - cz) + cx;
        double rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (pz - cz) + cz;
        double ry = Math.sin(pitch) * (rz - cz) + Math.cos(pitch) * (py - cy) + cy;
        rz = Math.cos(pitch) * (rz - cz) - Math.sin(pitch) * (py - cy) + cz;
        return new double[]{rx, ry, rz};
    }

    private void rotatePointAndDraw(MatrixStack matrix, IVertexBuilder buffer, float r, float g, float b, float a, double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch, boolean inverse) {
        double[] points = this.rotatePoint(px, py, pz, cx, cy, cz, yaw, pitch, inverse);
        buffer.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), (float)points[0], (float)points[1] - 1.0f, (float)points[2]).func_227885_a_(r, g, b, a).func_181675_d();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        revealedBlocks.removeIf(block -> block.getPos().equals((Object)event.getPos()));
    }
}

