/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class Blob
extends ParticleEffect {
    private final double random;
    private double mx;
    private double mz;
    private double theta;
    private final double wu;
    private final double r;
    private final float red;
    private final float green;
    private final float blue;
    private final boolean white;
    private final int maxAge;
    private final int colorPattern;
    private final float scale;
    private static final ResourceLocation tex = ResourceLocationHelper.of("pixelmon", "textures/particle/ultra.png");

    public Blob(double random, double theta, double wu, double r, float red, float green, float blue, boolean white, int maxAge, int colorPattern, float scale) {
        this.random = random;
        this.theta = theta;
        this.wu = wu;
        this.r = r;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.white = white;
        this.maxAge = maxAge;
        this.colorPattern = colorPattern;
        this.scale = scale;
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
    }

    @Override
    public void init(ParticleArcanery particle, World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(this.white ? 0.9f : this.red, this.white ? 0.9f : this.green, this.white ? 1.0f : this.blue, this.white ? 0.1f : 0.4f);
        particle.setMotion(vx, vy, vz);
        this.mx = vx;
        this.mz = vz;
        particle.setSize(this.scale);
        particle.func_187114_a(this.maxAge);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getSize() <= 0.03f || particle.getAge() >= particle.func_206254_h()) {
            particle.func_187112_i();
            return;
        }
        float newScale = this.scale * (1.0f - (float)particle.getAge() / (float)particle.func_206254_h());
        particle.setSize(newScale);
        this.theta += this.wu * (double)particle.getAge() / 2.0;
        this.mx = this.r * Math.cos(this.theta) / 18.0;
        this.mz = this.r * Math.sin(this.theta) / 18.0;
        particle.setMotion(this.mx, this.mz, particle.getMotionZ() - 0.03);
        if (particle.getMotionZ() < -0.75) {
            particle.setMotion(this.mx, this.mz, -0.75);
        }
        if (this.white) {
            particle.setRGBA(0.9f, 0.9f, 1.0f, 0.1f);
        } else {
            int colorSpeed = 40;
            int colorDeterminant = (particle.getAge() + (int)particle.getWorld().func_82737_E() % colorSpeed) % colorSpeed;
            particle.setRGBA(this.calcR(colorSpeed, colorDeterminant), this.calcG(colorSpeed, colorDeterminant), this.calcB(colorSpeed, colorDeterminant), 0.4f);
        }
    }

    public float calcChangingColor(int colorSpeed, int colorDeterminant) {
        float c1 = 1.0f / (float)colorSpeed;
        float c2 = c1 * (float)colorDeterminant;
        if (c2 > 0.5f) {
            float c3 = c2 - 0.5f;
            c2 -= c3 * 2.0f;
        }
        return c2;
    }

    public float calcR(int colorSpeed, int colorDeterminant) {
        switch (this.colorPattern) {
            case 0: 
            case 1: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 2: 
            case 3: {
                return 0.2f;
            }
            case 4: 
            case 5: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    public float calcG(int colorSpeed, int colorDeterminant) {
        switch (this.colorPattern) {
            case 2: 
            case 4: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 0: 
            case 5: {
                return 0.2f;
            }
            case 1: 
            case 3: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    public float calcB(int colorSpeed, int colorDeterminant) {
        switch (this.colorPattern) {
            case 3: 
            case 5: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 1: 
            case 4: {
                return 0.2f;
            }
            case 0: 
            case 2: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    @Override
    public ResourceLocation texture() {
        return tex;
    }
}

