/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.overlay.scoreboard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.Scoreboard;
import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientScoreboardFactory {
    private static final Map<String, BoardInfo> ACTIVE_BOARDS = Maps.newConcurrentMap();

    public static void addBoard(BoardInfo boardInfo) {
        ACTIVE_BOARDS.put(boardInfo.getBoard().getIdentifier().toLowerCase(Locale.ROOT), boardInfo);
    }

    public static void removeBoard(Scoreboard scoreboard) {
        ACTIVE_BOARDS.remove(scoreboard.getIdentifier().toLowerCase(Locale.ROOT));
    }

    public static List<BoardInfo> getActiveBoards() {
        return Lists.newArrayList(ACTIVE_BOARDS.values());
    }

    public static class BoardInfo {
        private Scoreboard board;
        private TargetPoint targetPoint;

        public BoardInfo(Scoreboard board) {
            this.board = board;
        }

        public BoardInfo(Scoreboard board, TargetPoint targetPoint) {
            this.board = board;
            this.targetPoint = targetPoint;
        }

        public Scoreboard getBoard() {
            return this.board;
        }

        public Optional<TargetPoint> getTargetPoint() {
            return Optional.ofNullable(this.targetPoint);
        }
    }
}

