/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.ResourceLocation;

public class GenericSmdModel
extends Model {
    public PixelmonModelRenderer modelRenderer;
    private ValveStudioModel model;
    private ResourceLocation pqcResource;
    private boolean overrideSmoothShading = false;

    public GenericSmdModel(ResourceLocation pqcResource, boolean overrideSmoothShading) {
        super(RenderType::func_228640_c_);
        this.overrideSmoothShading = overrideSmoothShading;
        this.pqcResource = pqcResource;
        this.reloadModel();
    }

    public GenericSmdModel(String basePath, String pqcPath, boolean overrideSmoothShading) {
        this(ResourceLocationHelper.of("pixelmon:" + basePath + "/" + pqcPath), overrideSmoothShading);
    }

    public GenericSmdModel(String basePath, String pqcPath) {
        this(basePath, pqcPath, false);
    }

    public void reloadModel() {
        this.modelRenderer = new PixelmonModelRenderer(this, "body");
        this.model = (ValveStudioModel)ValveStudioModelLoader.INSTANCE.loadModel(this.pqcResource, this.overrideSmoothShading);
        this.modelRenderer.addCustomModel(new ModelCustomWrapper(this.model));
    }

    public ValveStudioModel getModel() {
        return this.model;
    }

    public void setFrame(int frame) {
        ValveStudioModel valveStudioModel = (ValveStudioModel)this.modelRenderer.objs.get((int)0).model;
        SmdAnimation animation = valveStudioModel.currentSequence.checkForFinalFrame(frame);
        animation.setCurrentFrame((int)Math.floor(frame % animation.getNumFrames()));
        valveStudioModel.animate();
    }

    public void func_225598_a_(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.modelRenderer.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        this.modelRenderer.func_228309_a_(matrix, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

