/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.PixelmonSmdFactory;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;

public class DualModelFactory
extends PixelmonSmdFactory {
    protected ResourceWithFallback model2;
    protected float transparency = 1.0f;

    public DualModelFactory(ResourceWithFallback ... models) {
        super(models[0]);
        this.model2 = models[1];
    }

    public DualModelFactory setModel2Transparency(float transparency) {
        this.transparency = transparency;
        return this;
    }

    @Override
    public <T extends AbstractClientEntity> PixelmonModelSmd<T> createModel() {
        TransparentImpl impl = new TransparentImpl(this, DualModelFactory.loadModel(this.model.get()), DualModelFactory.loadModel(this.model2.get()));
        impl.body.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        impl.body.field_78795_f = this.rotateAngleX;
        impl.body.field_78796_g = this.rotateAngleY;
        impl.body2.func_78793_a(this.xRotation, this.yRotation, this.zRotation);
        impl.body2.field_78795_f = this.rotateAngleX;
        impl.body2.field_78796_g = this.rotateAngleY;
        impl.body2.setTransparent(this.transparency);
        impl.movementThreshold = this.movementThreshold;
        impl.animationIncrement = this.animationIncrement;
        return impl;
    }

    public static class TransparentImpl<T extends AbstractClientEntity>
    extends PixelmonSmdFactory.Impl<T> {
        protected PixelmonModelRenderer body2;
        protected ValveStudioModel model2;

        TransparentImpl(PixelmonSmdFactory factory, ValveStudioModel model, ValveStudioModel model2) {
            super(factory, model);
            this.model2 = model2;
            this.body2 = new PixelmonModelRenderer((Model)this, "body");
            this.body2.addCustomModel(new ModelCustomWrapper(model2));
        }

        @Override
        public void setScale(float scale) {
            super.setScale(scale);
            this.body2.scale = scale;
        }

        @Override
        public void render(Entity entity, MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            super.render(entity, matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.body2.func_228309_a_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }

        @Override
        protected void updateAnimation(IncrementingVariable variable) {
            IncrementingVariable ghostClone = variable.makeGhostClone();
            SmdAnimation animation = this.theModel.currentSequence.checkForIncrement(variable);
            int frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            animation.setCurrentFrame(frame);
            animation = this.model2.currentSequence.checkForIncrement(ghostClone);
            frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            animation.setCurrentFrame(frame);
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("pixelmon_animate");
            this.theModel.animate();
            this.model2.animate();
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }

        @Override
        protected void setAnimation(AnimationType animType) {
            this.theModel.setAnimation(animType);
            this.model2.setAnimation(animType);
        }
    }
}

