/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class PokemonUI {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer fontRenderer;
    private int leftOffset;
    private int topOffset;

    public PokemonUI(int leftOffset, int topOffset) {
        this.fontRenderer = this.mc.field_71466_p;
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
    }

    public void drawPokemon(MatrixStack matrix, Pokemon pokemon, int leftX, int topY, int mouseX, int mouseY, float zLevel) {
        this.drawPokemon(matrix, pokemon, leftX, topY, mouseX, mouseY, zLevel, false);
    }

    public void drawPokemon(MatrixStack matrix, Pokemon pokemon, int leftX, int topY, int mouseX, int mouseY, float zLevel, boolean highlight) {
        boolean offset = false;
        if (pokemon != null) {
            float color = highlight ? 0.5f : 1.0f;
            ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftX, topY - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, color, color, 1.0f, 1.0f);
            String displayName = pokemon.getDisplayName();
            this.fontRenderer.func_238421_b_(matrix, displayName, (float)(leftX + 28), (float)topY, 0xFFFFFF);
            if (!pokemon.isEgg()) {
                String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                float f = leftX + 29;
                this.fontRenderer.getClass();
                this.fontRenderer.func_238421_b_(matrix, levelString, f, (float)(topY + 1 + 9), 0xFFFFFF);
                if (pokemon.isFainted()) {
                    String string = I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    float f2 = leftX + 30 + this.fontRenderer.func_78256_a(levelString);
                    this.fontRenderer.getClass();
                    this.fontRenderer.func_238421_b_(matrix, string, f2, (float)(topY + 1 + 9), 0xFFFFFF);
                } else {
                    String string = I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftX + 31 + this.fontRenderer.func_78256_a(levelString);
                    this.fontRenderer.getClass();
                    this.fontRenderer.func_238421_b_(matrix, string, f3, (float)(topY + 1 + 9), 0xFFFFFF);
                }
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, matrix, this.fontRenderer.func_78256_a(displayName) + leftX + 29, topY, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, matrix, this.fontRenderer.func_78256_a(displayName) + leftX + 29, topY, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, leftX - 3, topY - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.fainted : Resources.normal;
            ScreenHelper.drawImageQuad(rl, matrix, leftX - 3, topY - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, leftX + 1, topY - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    public boolean isMouseOver(int leftX, int topY, double mouseX, double mouseY) {
        int left = leftX + this.leftOffset;
        int top = topY + this.topOffset - 5;
        return mouseX > (double)left && mouseX < (double)(left + 110) && mouseY > (double)top && mouseY < (double)(top + 25);
    }
}

