/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.statueEditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.PokeDisplaySwapPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.PokeDisplayUpdatePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PokeDisplayEditor
extends DropDownScreen {
    private PokeDisplayTileEntity displayTileEntity;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private float savedX = 0.0f;
    private float savedY = 0.0f;
    private float scale = 0.0f;
    private float savedRotationX = 180.0f;
    private float savedRotationY = 0.0f;
    private boolean paused = false;
    private boolean showAxies = false;
    private IndexedButton animateButton;
    private IndexedButton axisButton;
    private TextFieldWidget tbLabel;
    private TextFieldWidget tbFrame;
    int controlWidth = 145;
    int controlLeft;
    int controlHeight;
    int controlTop;
    Model lastModel;
    private boolean requiresUpdate = false;
    private Pokemon initial;
    private DropDown<Pokemon> partyDropDown;
    private DropDown<Stats> formDropDown;
    int lastFrame;

    public PokeDisplayEditor(BlockPos tileEntity) {
        super(StringTextComponent.field_240750_d_);
        PokeDisplayTileEntity statue;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        TileEntity entity = Minecraft.func_71410_x().field_71441_e.func_175625_s(tileEntity);
        if (entity instanceof PokeDisplayTileEntity && Objects.equals((statue = (PokeDisplayTileEntity)entity).func_174877_v(), tileEntity)) {
            this.displayTileEntity = statue;
            this.initial = statue.getStoredPoke().orElse(null);
        }
    }

    @Override
    public void func_231160_c_() {
        if (this.displayTileEntity == null) {
            ScreenHelper.closeScreen();
            return;
        }
        Species species = this.displayTileEntity.getStoredEntity().getSpecies();
        if (species == null) {
            ScreenHelper.closeScreen();
            return;
        }
        super.func_231160_c_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        this.controlLeft = 10;
        this.controlTop = 10;
        this.controlHeight = this.field_230709_l_ - 20;
        int buttonHeight = 20;
        int textFieldHeight = 10;
        ArrayList pokes = Lists.newArrayList(ClientStorageManager.party.getTeam());
        if (this.displayTileEntity.getStoredEntity().getPokemon().getSpecies().is(PixelmonSpecies.MISSINGNO)) {
            this.requiresUpdate = true;
            Pokemon pokeToBeStored = ClientStorageManager.party.getFirstAblePokemon();
            this.displayTileEntity.setStoredPoke(pokeToBeStored);
            this.displayTileEntity.setOriginalForm(pokeToBeStored.getForm().getName());
            this.displayTileEntity.setOriginalPalette(pokeToBeStored.getPalette().getName());
        } else if (this.initial != null) {
            pokes.add(this.initial);
        }
        int partyWidth = Math.min(150, Math.max(80, pokes.stream().mapToInt(f -> this.field_230706_i_.field_71466_p.func_78256_a(f.getLocalizedName())).max().orElse(0)));
        this.partyDropDown = this.addDropDown(new DropDown<Pokemon>(pokes, this.displayTileEntity.getStoredEntity().getPokemon(), this.controlLeft + 45, this.controlTop + 2, partyWidth, 150).setGetOptionString(Pokemon::getDisplayName).setOnSelected(poke -> {
            this.requiresUpdate = poke.getStorage() != null;
            this.displayTileEntity.setStoredPoke((Pokemon)poke);
            this.displayTileEntity.setOriginalForm(poke.getForm().getName());
            this.displayTileEntity.setOriginalPalette(poke.getPalette().getName());
        }).setInactiveTop(this.controlTop + 2));
        this.tbLabel = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.controlLeft + 45, this.controlTop + 18, this.controlWidth - 55, textFieldHeight, StringTextComponent.field_240750_d_);
        this.tbLabel.func_146180_a(this.displayTileEntity.getLabel());
        this.tbLabel.func_212954_a(this::setLabel);
        this.lastModel = this.displayTileEntity.getStoredEntity().getModel();
        this.field_230705_e_.add(this.tbLabel);
        this.tbFrame = null;
        int animTop = this.controlTop + 33;
        List<AnimationType> anims = this.displayTileEntity.getAllAnimations();
        ArrayList<String> animStrings = new ArrayList<String>();
        for (AnimationType anim : anims) {
            animStrings.add(anim.toString().toLowerCase(Locale.ROOT));
        }
        this.addDropDown(new DropDown<String>(animStrings, this.displayTileEntity.getAnimation().toString().toLowerCase(Locale.ROOT), this.controlLeft + 45, animTop + Math.max(-16, (anims.size() - 1) * -10), 80, 100).setGetOptionString(animation -> I18n.func_135052_a((String)("gui.model." + animation), (Object[])new Object[0])).setOnSelected(this::selectAnimation).setInactiveTop(this.controlTop + 33));
        this.tbFrame = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.controlLeft + 45, this.controlTop + 48, 40, textFieldHeight, StringTextComponent.field_240750_d_);
        this.tbFrame.func_146180_a(this.displayTileEntity.getAnimationFrame() + "");
        this.tbFrame.func_212954_a(this::setFrame);
        this.lastFrame = this.displayTileEntity.getAnimationFrame();
        this.field_230705_e_.add(this.tbFrame);
        ArrayList forms = Lists.newArrayList();
        if (this.displayTileEntity.getStoredPoke().isPresent()) {
            forms.add(this.displayTileEntity.getStoredPoke().get().getSpecies().getForm(this.displayTileEntity.getOriginalForm()));
        }
        forms.addAll(this.displayTileEntity.getStoredEntity().getSpecies().getForms(Stats::isTemporary));
        int width = Math.min(150, Math.max(80, forms.stream().mapToInt(f -> this.field_230706_i_.field_71466_p.func_78256_a(f.getLocalizedName())).max().orElse(0)));
        this.formDropDown = this.addDropDown(new DropDown<Stats>(forms, this.displayTileEntity.getStoredEntity().getForm(), this.controlLeft + 45, this.controlTop + 63, width, 150).setGetOptionString(stats -> {
            if (stats.getLocalizedName().isEmpty()) {
                return "Default";
            }
            return stats.getLocalizedName();
        }).setOnSelected(form -> {
            if (form.getName() == null) {
                return;
            }
            NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetForm, this.displayTileEntity, form.getName()));
            this.displayTileEntity.getStoredEntity().getPokemon().setForm((Stats)form);
            if (this.displayTileEntity.isFlying()) {
                this.changeFlying(false);
            }
        }).setInactiveTop(this.controlTop + 63));
        ArrayList textures = Lists.newArrayList((Object[])EnumStatueTextureType.values());
        EnumStatueTextureType current = this.displayTileEntity.getTextureMode();
        this.addDropDown(new DropDown<EnumStatueTextureType>(textures, current, this.controlLeft + 45, this.controlTop + 78, 80, 120).setGetOptionString(ITranslatable::getLocalizedName).setOnSelected(texture -> {
            NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetTextureType, this.displayTileEntity, texture.toString()));
            this.displayTileEntity.setTextureMode((EnumStatueTextureType)texture);
        }).setInactiveTop(this.controlTop + 78));
        this.animateButton = new IndexedButton(2, this.controlLeft + 5, this.field_230709_l_ - 60, 60, buttonHeight, I18n.func_135052_a((String)"gui.animate.text", (Object[])new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.animateButton);
        this.axisButton = new IndexedButton(12, this.controlLeft + this.controlWidth - 60 - 6, this.field_230709_l_ - 60, 60, buttonHeight, I18n.func_135052_a((String)"gui.axis_on.text", (Object[])new Object[0]), this::actionPerformed);
        this.func_230480_a_((Widget)this.axisButton);
        this.func_230480_a_((Widget)new IndexedButton(1, this.controlLeft + 5, this.field_230709_l_ - 35, this.controlWidth - 10, buttonHeight, I18n.func_135052_a((String)"gui.save.text", (Object[])new Object[0]), this::actionPerformed));
    }

    public void setSpecies(String s) {
        Optional<Species> species = PixelmonSpecies.fromNameOrDex(s);
        if (!species.isPresent() || species.get().is(PixelmonSpecies.MISSINGNO)) {
            return;
        }
        if (this.displayTileEntity.getStoredEntity().getSpecies() == species.get()) {
            return;
        }
        NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetName, this.displayTileEntity, species.get().getName()));
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void setLabel(String s) {
        this.displayTileEntity.setLabel(s);
    }

    private void setFrame(String s) {
        int frame;
        int n = frame = s.isEmpty() ? 0 : NumberHelper.parseInteger(s).orElseGet(() -> {
            this.tbFrame.func_146180_a("");
            return 0;
        });
        if (frame < 0) {
            frame = 0;
            this.tbFrame.func_146180_a("");
        } else if (frame >= this.displayTileEntity.getFrameCount()) {
            frame = this.displayTileEntity.getFrameCount() - 1;
            this.tbFrame.func_146180_a(String.valueOf(frame));
        }
        if (frame != this.lastFrame) {
            this.displayTileEntity.setAnimationFrame(frame);
            NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetAnimationFrame, this.displayTileEntity, frame));
            this.lastFrame = frame;
        }
    }

    private void selectAnimation(String nextAnim) {
        this.displayTileEntity.setAnimation(AnimationType.getTypeFor(nextAnim));
        NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetAnimation, this.displayTileEntity, nextAnim));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean unicode = Minecraft.func_71410_x().func_211821_e();
        Minecraft.func_71410_x().func_238209_b_(true);
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            Minecraft.func_71410_x().func_238209_b_(unicode);
            return true;
        }
        this.mouseClickedUnderMenus(mouseX, mouseY, button);
        Minecraft.func_71410_x().func_238209_b_(unicode);
        return true;
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.func_231047_b_(mouseX, mouseY)) {
            this.scale = (float)((double)this.scale + delta * 10.0);
            if (this.scale < 0.0f) {
                this.scale = 0.0f;
            }
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public void func_231175_as__() {
        int pos = -1;
        if (this.requiresUpdate && this.displayTileEntity.getStoredEntity().getStorage() != null && this.displayTileEntity.getStoredEntity().getStorage().getPosition(this.displayTileEntity.getStoredEntity().getPokemon()) != null) {
            pos = this.displayTileEntity.getStoredEntity().getPartyPosition();
        }
        NetworkHelper.sendToServer(new PokeDisplaySwapPacket(this.displayTileEntity.func_174877_v(), pos));
        ScreenHelper.closeScreen();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        this.tbLabel.func_231044_a_(x, y, mouseButton);
        if (this.tbFrame != null) {
            this.tbFrame.func_231044_a_(x, y, mouseButton);
        }
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    protected void actionPerformed(Button guiButton) {
        int id = ((IndexedButton)guiButton).id;
        if (id == 1) {
            this.func_231175_as__();
        } else if (id == 2) {
            boolean shouldAnimate;
            boolean bl = shouldAnimate = !this.displayTileEntity.isAnimate();
            if (!shouldAnimate) {
                this.animateButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.animate.text"));
            } else {
                this.animateButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.pause.text"));
            }
            NetworkHelper.sendToServer(new PokeDisplayUpdatePacket(EnumStatuePacketMode.SetShouldAnimate, this.displayTileEntity, shouldAnimate));
            this.displayTileEntity.setAnimate(shouldAnimate);
        } else if (id == 10) {
            this.changeFlying(!this.displayTileEntity.isFlying());
        } else if (id == 11) {
            this.paused = !this.paused;
        } else if (id == 12) {
            boolean bl = this.showAxies = !this.showAxies;
            if (!this.showAxies) {
                this.axisButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.axis_on.text"));
            } else {
                this.axisButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.axis_off.text"));
            }
        }
    }

    private void changeFlying(boolean isFlying) {
        this.displayTileEntity.setFlying(isFlying);
        String extra = isFlying ? "flying" : "standing";
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX > 0.0 && mouseX <= (double)this.controlWidth;
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawGradientRect(matrix, this.controlLeft, this.controlTop, 0.0f, this.controlLeft + this.controlWidth, this.controlTop + this.controlHeight, -1713512995, -1713512995);
        if (this.displayTileEntity.getModel() != this.lastModel) {
            int i = this.field_230706_i_.func_228018_at_().func_198107_o();
            int j = this.field_230706_i_.func_228018_at_().func_198087_p();
            this.func_231158_b_(this.field_230706_i_, i, j);
            this.lastModel = this.displayTileEntity.getModel();
        }
        String text = I18n.func_135052_a((String)"gui.trainereditor", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 3), 0, false, true);
        text = I18n.func_135052_a((String)"gui.label.text", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 18), 0, false, true);
        if (this.tbFrame != null) {
            text = I18n.func_135052_a((String)"gui.model.animation", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 33), 0, false, true);
            text = I18n.func_135052_a((String)"gui.model.frame", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 48), 0, false, true);
            text = "/" + (this.displayTileEntity.getFrameCount() - 1);
            ScreenHelper.drawString(matrix, text, this.controlLeft + 90, (float)(this.controlTop + 48), 0, false, true);
        }
        if (this.formDropDown != null && this.formDropDown.getVisible()) {
            text = I18n.func_135052_a((String)"gui.trainereditor.form", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 63), 0, false, true);
        }
        text = I18n.func_135052_a((String)"gui.texture.text", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, text, this.controlLeft + 5, (float)(this.controlTop + 78), 0, false, true);
        PokeDisplayTileEntity ep = this.displayTileEntity;
        if (ep != null && ep.getModel() != null) {
            this.drawEntityToScreen(matrix, (this.field_230708_k_ + this.controlWidth) / 2 - 10, this.field_230709_l_ / 2 + 20, 200, 200, ep.getStoredEntity(), partialTicks, !this.paused);
        }
    }

    public void drawEntityToScreen(MatrixStack matrix, int x, int y, int w, int l, PixelmonEntity e, float pt, boolean spin) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)((float)x + this.savedX), (double)((float)y + this.savedY), 100.0);
        float eheight = (float)l / e.func_213302_cg() / 4.0f;
        float ewidth = (float)l / e.func_213311_cf() / 4.0f;
        float scalar = eheight > ewidth ? eheight : ewidth;
        matrix.func_227862_a_(scalar + Math.max(0.0f, this.scale), scalar + Math.max(0.0f, this.scale), scalar + Math.max(0.0f, this.scale));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(this.savedRotationY + this.rotationY, 1.0f, 0.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(this.savedRotationX + this.rotationX, 0.0f, 1.0f, 0.0f));
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view == null) {
            view = Minecraft.func_71410_x().field_71439_g;
        }
        float tx = (float)(view.field_70169_q + (view.func_226277_ct_() - view.field_70169_q) * (double)pt);
        float tz = (float)(view.field_70166_s + (view.func_226281_cx_() - view.field_70166_s) * (double)pt);
        float angle = (float)(Math.atan2(e.func_226281_cx_() - (double)tz, e.func_226277_ct_() - (double)tx) * 180.0 / Math.PI) + 90.0f;
        float dist = e.func_70032_d(view) - 20.0f;
        matrix.func_227863_a_(QuaternionHelper.fromEuler(-angle + 45.0f, 0.0f, 1.0f, 0.0f));
        PixelmonRendering.renderEntity(matrix, e, true, pt);
        if (this.showAxies) {
            this.drawAxis(matrix, 0.1f, 0.1f, Color.RED, QuaternionHelper.fromEuler(0.0f, 0.0f, 0.0f, 0.0f));
            this.drawAxis(matrix, 0.1f, 0.1f, Color.BLUE, QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
            this.drawAxis(matrix, 0.1f, 0.1f, Color.GREEN, QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
        }
        matrix.func_227865_b_();
    }

    private void drawAxis(MatrixStack matrix, float scale, float height, Color color, Quaternion axis) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(scale, scale, scale);
        matrix.func_227863_a_(axis);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        for (int i = 0; i < 5; ++i) {
            ScreenHelper.drawQuad(matrix, -this.field_230708_k_, 0.0f, 0.0f, this.field_230708_k_, 0.0f, 0.0f, this.field_230708_k_, height, 0.0f, -this.field_230708_k_, height, 0.0f, color);
            matrix.func_227860_a_();
            matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            ScreenHelper.drawQuad(matrix, -this.field_230708_k_, 0.0f, 0.0f, this.field_230708_k_, 0.0f, 0.0f, this.field_230708_k_, height, 0.0f, -this.field_230708_k_, height, 0.0f, color);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (mouseX < 0.0 || mouseX > (double)this.field_230708_k_ || mouseY < 0.0 || mouseY > (double)this.field_230709_l_) {
            return true;
        }
        if (this.func_231047_b_(mouseX, mouseY)) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        if (button == 0) {
            this.savedRotationX = (float)((double)this.savedRotationX - dragX);
            this.savedRotationY = (float)((double)this.savedRotationY + dragY);
            return true;
        }
        if (button == 1) {
            this.savedX = (float)((double)this.savedX + dragX);
            this.savedY = (float)((double)this.savedY + dragY);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.savedRotationX += this.rotationX;
            this.savedRotationY += this.rotationY;
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    public void func_230446_a_(MatrixStack matrix) {
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.field_230708_k_, this.field_230709_l_, -1725816286, -1725816286);
    }
}

