/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.raids.PokemonSlot;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.RaidActionPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class RaidStartScreen
extends Screen {
    private static final ResourceLocation WATERMARK = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/watermark.png");
    private static final ResourceLocation STAR = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/star.png");
    private final ArrayList<RaidButton> buttons = new ArrayList();
    private final ArrayList<PokemonSlot> slots = new ArrayList();
    private RaidData raid;
    private PixelmonEntity pixelmon;
    private boolean shouldRefresh = false;
    private float fadeout = 0.0f;
    private int seconds = 0;
    private boolean closing = false;

    public RaidStartScreen(RaidData raid) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.setRaid(raid, null);
    }

    public void setRaid(RaidData raid, RaidStartScreen old) {
        this.raid = raid;
        if (old != null) {
            this.pixelmon = old.pixelmon;
        } else {
            Pokemon pokemon = PokemonFactory.create(raid.getSpecies());
            if (raid.getForm() != null) {
                pokemon.setForm(raid.getForm());
            }
            pokemon.setGrowth(EnumGrowth.Ordinary);
            this.pixelmon = new PixelmonEntity((World)this.field_230706_i_.field_71441_e, pokemon);
            this.pixelmon.setAnimation(AnimationType.IDLE);
            this.pixelmon.checkAnimation();
            this.pixelmon.initAnimation();
        }
        this.shouldRefresh = true;
    }

    private void initButtons() {
        this.buttons.clear();
        this.slots.clear();
        this.buttons.add(new RaidButton((double)this.field_230708_k_ / 1.45, (double)this.field_230709_l_ / 1.15 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, (float)this.field_230708_k_ / 4.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.solo", (Object[])new Object[0]), this.raid, button -> NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 6))).setEnabled(!this.raid.isStarting()).setVisible(this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_230708_k_ / 1.45, (double)this.field_230709_l_ / 1.15 - (double)((int)((double)this.field_230709_l_ * 0.08 * 2.0)), 1.0, (float)this.field_230708_k_ / 4.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.start", (Object[])new Object[0]), this.raid, button -> NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 9))).setEnabled(!this.raid.isStarting() && this.raid.isOwner(this.field_230706_i_.field_71439_g.func_110124_au())).setVisible(!this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_230708_k_ / 1.45, (double)this.field_230709_l_ / 1.15 - (double)((int)((double)this.field_230709_l_ * 0.08)), 1.0, (float)this.field_230708_k_ / 4.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.multi", (Object[])new Object[0]), this.raid, button -> NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 7))).setEnabled(!this.raid.isStarting()).setVisible(this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_230708_k_ / 1.45, (double)this.field_230709_l_ / 1.15 - (double)((int)((double)this.field_230709_l_ * 0.08)), 1.0, (float)this.field_230708_k_ / 4.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.players", (Object[])new Object[]{this.raid.getPlayers().size()}), this.raid, button -> {}).setEnabled(false).setVisible(!this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_230708_k_ / 1.45, (double)this.field_230709_l_ / 1.15, 1.0, (float)this.field_230708_k_ / 4.0f, (float)this.field_230709_l_ / 17.0f, I18n.func_135052_a((String)"raid.button.quit", (Object[])new Object[0]), this.raid, button -> {
            this.closing = true;
            NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 8));
        }).setEnabled(!this.raid.isStarting()));
        float xGap = (float)this.field_230708_k_ * 0.075f;
        float yGap = (float)this.field_230709_l_ * 0.1f;
        ArrayList<RaidData.RaidPlayer> players = this.raid.getPlayers();
        for (int i = 0; i < 4; ++i) {
            RaidData.RaidPlayer player = players.size() > i ? players.get(i) : null;
            this.slots.add(new PokemonSlot(this.raid, (double)((float)this.field_230708_k_ / 1.1f), (double)((float)this.field_230709_l_ * 0.08f + yGap * (float)i), 2.0, player, button -> {}).setEnabled(false));
        }
        Pokemon[] party = ClientStorageManager.party.getAll();
        for (int i = 0; i < 6; ++i) {
            int xPos = i;
            boolean yPos = false;
            if (i >= 3) {
                xPos -= 3;
                yPos = true;
            }
            int index = i;
            this.slots.add(new PokemonSlot(this.raid, (double)((float)this.field_230708_k_ * 0.755f + xGap * (float)xPos), (double)((float)this.field_230709_l_ * 0.55f + yGap * (float)yPos), 2.0, party[index], button -> {
                if (party[index] != null && party[index].canBattle()) {
                    SoundHelper.playButtonPressSound();
                    NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), index));
                }
            }).setEnabled(!this.raid.isStarting()).setIndex(index));
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_.field_71439_g == null || this.field_230706_i_.field_71439_g.func_233643_dh_()) {
            this.func_231175_as__();
        }
        if (this.buttons.isEmpty() || this.shouldRefresh) {
            this.shouldRefresh = false;
            this.initButtons();
        }
        this.func_230446_a_(matrix);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.raid.isStarting()) {
            int seconds = 5 - this.raid.tick / 20;
            if (this.seconds != seconds) {
                SoundHelper.playSound(SoundEvents.field_193807_ew, 0.8f, 1.5f);
                this.seconds = seconds;
                this.fadeout = 255.0f;
            }
            this.raid.getDenEntity((World)this.field_230706_i_.field_71441_e).map(den -> {
                Color c2 = den.getColorUIB();
                Color color = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), Math.max(0, (int)this.fadeout));
                ScreenHelper.drawScaledCenteredString(matrix, String.valueOf(this.seconds), (float)this.field_230708_k_ * 0.8f, (float)this.field_230709_l_ * 0.13f, color.getRGB(), (float)this.field_230708_k_ * 0.25f);
                return true;
            }).orElseGet(() -> {
                Color color = new Color(226, 75, 66, Math.max(0, (int)this.fadeout));
                ScreenHelper.drawScaledCenteredString(matrix, String.valueOf(this.seconds), (float)this.field_230708_k_ * 0.8f, (float)this.field_230709_l_ * 0.13f, color.getRGB(), (float)this.field_230708_k_ * 0.25f);
                return true;
            });
            this.fadeout -= 1.5f;
        }
        int starSize = (int)((double)this.field_230708_k_ * 0.05);
        for (int i = 0; i < this.raid.getStars(); ++i) {
            ScreenHelper.drawImage(matrix, STAR, (float)((double)starSize * 0.75 + (double)(i * starSize)), (float)((double)starSize * 0.6), (float)starSize, (float)starSize, 1.0f);
        }
        List<Element> types = this.pixelmon.getForm().getTypes();
        for (int i = 0; i < types.size(); ++i) {
            Element element = types.get(i);
            float x = element.textureX;
            float y = element.textureY;
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, (float)starSize * 0.75f + (float)(i * starSize), (float)starSize * 2.0f, starSize, starSize, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (RaidButton raidButton : this.buttons) {
            raidButton.draw(matrix, mouseX, mouseY, partialTicks);
        }
        RaidData.RaidPlayer player = this.raid.getPlayer(this.field_230706_i_.field_71439_g.func_110124_au());
        for (PokemonSlot slot : this.slots) {
            slot.draw(matrix, mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, player != null && player.index == slot.getIndex() || slot.isPlayer(this.field_230706_i_.field_71439_g.func_110124_au()), partialTicks);
        }
        boolean bl = !this.raid.canAllCatch;
        String desc = I18n.func_135052_a((String)(bl ? "raid.lorespecial" : "raid.lore"), (Object[])new Object[]{4, 10});
        String[] split = desc.split("\\\\n");
        int lineCount = 0;
        for (String line : split) {
            ScreenHelper.drawScaledString(matrix, line, (float)this.field_230708_k_ * 0.025f, (float)this.field_230709_l_ * (bl ? 0.82f : 0.88f) + (float)this.field_230709_l_ * 0.03f * (float)lineCount, 0xFFFFFF, (float)this.field_230709_l_ * 0.05f);
            ++lineCount;
        }
        ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)"raid.choose", (Object[])new Object[0]), (float)this.field_230708_k_ * 0.855f, (float)this.field_230709_l_ * 0.46f, -1, (float)this.field_230708_k_ * 0.03f);
        matrix.func_227860_a_();
        RenderSystem.enableDepthTest();
        matrix.func_227861_a_((double)((float)this.field_230708_k_ / 4.0f), (double)((float)this.field_230709_l_ / 4.0f * 3.0f), 300.0);
        double referenceW = (float)this.field_230709_l_ / 3.0f;
        double referenceH = (float)this.field_230709_l_ / 3.0f;
        double dh = this.pixelmon.getForm().getDimensions().getHeight() - referenceH;
        double dw = this.pixelmon.getForm().getDimensions().getWidth() - referenceW;
        float scalar = 1.0f;
        scalar = dh > dw ? (float)(referenceH / this.pixelmon.getForm().getDimensions().getHeight()) : (float)(referenceW / this.pixelmon.getForm().getDimensions().getWidth());
        matrix.func_227862_a_(scalar, scalar, scalar);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        RenderHelper.func_227780_a_();
        try {
            EntityRendererManager renderManager = this.field_230706_i_.func_175598_ae();
            this.pixelmon.setRenderColor(0.0f, 0.0f, 0.0f, 1.0f);
            EntityRenderer entityClassRenderObject = renderManager.func_78713_a((Entity)this.pixelmon);
            PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
            IRenderTypeBuffer.Impl buffer = ScreenHelper.getBufferImpl();
            rp.render(this.pixelmon, 0.0f, partialTicks, matrix, (IRenderTypeBuffer)buffer, renderManager.func_229085_a_((Entity)this.pixelmon, partialTicks));
            buffer.func_228461_a_();
            renderManager.func_229089_a_(Vector3f.field_229181_d_.func_229193_c_(180.0f));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        matrix.func_227865_b_();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (RaidButton button : this.buttons) {
            button.onClick(mouseX, mouseY, mouseButton);
        }
        for (PokemonSlot slot : this.slots) {
            slot.onClick(mouseX, mouseY, mouseButton);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_230446_a_(MatrixStack matrix) {
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.field_230708_k_, this.field_230709_l_, -1596523265, -1866285374);
        int right = this.field_230708_k_ / 3 * 2;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)right, 0.0, 0.0);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(25.0f, 0.0f, 0.0f, 1.0f));
        float[] c = this.raid.getDenEntity((World)this.field_230706_i_.field_71441_e).map(den -> {
            ScreenHelper.drawGradientRect(matrix, -right, 0, 0.0f, 0, this.field_230709_l_ * 2, den.getColorUIA().getRGB(), den.getColorUIB().getRGB());
            Color c3 = den.getColorUIC();
            return new float[]{(float)c3.getRed() / 255.0f, (float)c3.getGreen() / 255.0f, (float)c3.getBlue() / 255.0f, 0.2f};
        }).orElseGet(() -> {
            ScreenHelper.drawGradientRect(matrix, -right, 0, 0.0f, 0, this.field_230709_l_ * 2, -37796, -5752007);
            return new float[]{0.8f, 0.0f, 0.0f, 0.2f};
        });
        matrix.func_227865_b_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.func_227860_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(25.0f, 0.0f, 0.0f, 1.0f));
        ScreenHelper.drawImage(matrix, WATERMARK, (float)this.field_230708_k_ / 6.0f, (float)(-this.field_230709_l_) / 4.0f, (float)this.field_230708_k_ / 2.5f, (float)this.field_230708_k_ / 2.5f * 1.655914f, c[0], c[1], c[2], c[3], 0.0f);
        matrix.func_227865_b_();
    }

    public void func_231023_e_() {
        this.pixelmon.getAnimationVariables().tick();
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        super.func_231152_a_(minecraft, width, height);
        this.initButtons();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231164_f_() {
        if (!this.closing && !this.raid.isStarting()) {
            this.closing = true;
            NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 8));
        }
    }

    public boolean func_231178_ax__() {
        return !this.raid.isStarting();
    }
}

