/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.override.multiplayer.CustomMultiplayerScreen;
import com.pixelmonmod.pixelmon.client.gui.override.multiplayer.CustomServerData;
import com.pixelmonmod.pixelmon.client.gui.override.multiplayer.CustomServerList;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomServerSelectionList
extends ExtendedList<Entry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("pixelmon", "textures/icon_32x32.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private static final ITextComponent SCANNING_LABEL = new TranslationTextComponent("lanServer.scanning");
    private static final ITextComponent CANT_RESOLVE_TEXT = new TranslationTextComponent("multiplayer.status.cannot_resolve").func_240699_a_(TextFormatting.DARK_RED);
    private static final ITextComponent CANT_CONNECT_TEXT = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.DARK_RED);
    private static final ITextComponent INCOMPATIBLE_TOOLTIP = new TranslationTextComponent("multiplayer.status.incompatible");
    private static final ITextComponent NO_CONNECTION_TOOLTIP = new TranslationTextComponent("multiplayer.status.no_connection");
    private static final ITextComponent PINGING_TOOLTIP = new TranslationTextComponent("multiplayer.status.pinging");
    private final CustomMultiplayerScreen screen;
    private final List<NormalEntry> onlineServers = Lists.newArrayList();
    private final Entry lanHeader = new LanScanEntry();
    private final List<LanDetectedEntry> networkServers = Lists.newArrayList();
    private Entry selected;

    public CustomServerSelectionList(CustomMultiplayerScreen p_i45049_1_, Minecraft p_i45049_2_, int p_i45049_3_, int p_i45049_4_, int p_i45049_5_, int p_i45049_6_, int p_i45049_7_) {
        super(p_i45049_2_, p_i45049_3_, p_i45049_4_, p_i45049_5_, p_i45049_6_, p_i45049_7_);
        this.screen = p_i45049_1_;
    }

    private void refreshEntries() {
        this.func_230963_j_();
        this.onlineServers.forEach(this::addEntry);
        this.addEntry(this.lanHeader);
        this.networkServers.forEach(this::addEntry);
    }

    protected int addEntry(Entry p_230513_1_) {
        return super.func_230513_b_((AbstractList.AbstractListEntry)p_230513_1_);
    }

    public void setSelected(@Nullable Entry selected) {
        this.selected = selected;
        if (this.getSelected() instanceof NormalEntry) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new Object[]{((NormalEntry)((NormalEntry)this.getSelected())).serverData.field_78847_a}).getString());
        }
        this.screen.func_214295_b();
    }

    public Entry getSelected() {
        return this.selected;
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        Entry serverselectionlist$entry = this.getSelected();
        return serverselectionlist$entry != null && serverselectionlist$entry.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_) || super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    protected void func_241219_a_(AbstractList.Ordering p_241219_1_) {
        this.func_241572_a_(p_241219_1_, p_241612_0_ -> !(p_241612_0_ instanceof LanScanEntry));
    }

    public void updateOnlineServers(CustomServerList p_148195_1_) {
        this.onlineServers.clear();
        for (int i = 0; i < p_148195_1_.func_78856_c(); ++i) {
            this.onlineServers.add(new NormalEntry(this, this.screen, p_148195_1_.getServer(i)));
        }
        this.refreshEntries();
    }

    public void updateNetworkServers(List<LanServerInfo> p_148194_1_) {
        this.networkServers.clear();
        for (LanServerInfo lanserverinfo : p_148194_1_) {
            this.networkServers.add(new LanDetectedEntry(this.screen, lanserverinfo));
        }
        this.refreshEntries();
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 30;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 85;
    }

    protected boolean func_230971_aw__() {
        return this.screen.func_241217_q_() == this;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        this.func_230947_b_(p_231044_1_, p_231044_3_, p_231044_5_);
        if (!this.func_231047_b_(p_231044_1_, p_231044_3_)) {
            return false;
        }
        Entry e = this.entryAtPosition(p_231044_1_, p_231044_3_);
        if (e != null) {
            if (e.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
                this.func_231035_a_((IGuiEventListener)e);
                this.func_231037_b__(true);
                return true;
            }
        } else if (p_231044_5_ == 0) {
            this.func_230938_a_((int)(p_231044_1_ - (double)(this.field_230675_l_ + this.field_230670_d_ / 2 - this.func_230949_c_() / 2)), (int)(p_231044_3_ - (double)this.field_230672_i_) + (int)this.func_230966_l_() - 4);
            return true;
        }
        return true;
    }

    protected Entry entryAtPosition(double p_230933_1_, double p_230933_3_) {
        int i = this.func_230949_c_() / 2;
        int j = this.field_230675_l_ + this.field_230670_d_ / 2;
        int k = j - 2 * i;
        int l = j + i;
        int i1 = MathHelper.func_76128_c((double)(p_230933_3_ - (double)this.field_230672_i_)) - this.field_230677_n_ + (int)this.func_230966_l_() - 4;
        int j1 = i1 / this.field_230669_c_;
        return p_230933_1_ < (double)this.func_230952_d_() && p_230933_1_ >= (double)k && p_230933_1_ <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.func_230965_k_() ? (Entry)((Object)this.func_231039_at__().get(j1)) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NormalEntry
    extends Entry {
        private final CustomMultiplayerScreen screen;
        private final Minecraft minecraft;
        private final CustomServerData serverData;
        private final ResourceLocation iconLocation;
        private String lastIconB64;
        private DynamicTexture icon;
        private long lastClickTime;
        private ScrollEntry[] scrollData;
        private CustomServerSelectionList list;

        protected NormalEntry(CustomServerSelectionList list, CustomMultiplayerScreen p_i50669_2_, CustomServerData p_i50669_3_) {
            this.scrollData = new ScrollEntry[]{new ScrollEntry(), new ScrollEntry()};
            this.list = list;
            this.screen = p_i50669_2_;
            this.serverData = p_i50669_3_;
            this.minecraft = Minecraft.func_71410_x();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)p_i50669_3_.field_78845_b) + "/icon");
            this.icon = (DynamicTexture)this.minecraft.func_110434_K().func_229267_b_(this.iconLocation);
        }

        public void func_230432_a_(MatrixStack matrix, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            List list1;
            ITextComponent itextcomponent;
            int l;
            int j1;
            int i1;
            int l1;
            int k1;
            if (!this.serverData.field_78841_f) {
                this.serverData.field_78841_f = true;
                this.serverData.field_78844_e = -2L;
                this.serverData.field_78843_d = StringTextComponent.field_240750_d_;
                this.serverData.field_78846_c = StringTextComponent.field_240750_d_;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.func_146789_i().func_147224_a((ServerData)this.serverData, () -> this.minecraft.execute(this::updateServerList));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.field_78844_e = -1L;
                        this.serverData.field_78843_d = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception exception) {
                        this.serverData.field_78844_e = -1L;
                        this.serverData.field_78843_d = CANT_CONNECT_TEXT;
                    }
                });
            }
            if (mouseX > p_230432_4_ - 20 && mouseX < p_230432_4_ && mouseY < p_230432_3_ + 32 && mouseY > p_230432_3_ + 8 || this.screen.getServers().isFavourite(this.serverData)) {
                ScreenHelper.drawStar(matrix, p_230432_4_ - 18, p_230432_3_ + 16, 0.0, 7.143, 2.858, 5, false, 0.95f, 0.85f, 0.35f, 1.0f);
            } else {
                ScreenHelper.drawStar(matrix, p_230432_4_ - 18, p_230432_3_ + 16, 0.0, 7.143, 2.858, 5, true, 0.95f, 0.85f, 0.35f, 1.0f);
            }
            if (this.serverData.goldBorder && !Objects.equals((Object)this, (Object)this.list.getSelected())) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
                k1 = this.list.func_230949_c_();
                l1 = this.list.getLeft() + this.list.field_230670_d_ / 2 - k1 / 2;
                int i2 = this.list.getLeft() + this.list.getWidth() / 2 + k1 / 2;
                i1 = p_230432_3_ + this.list.field_230677_n_;
                j1 = this.list.field_230669_c_ - 4;
                RenderSystem.disableTexture();
                float f = this.list.func_230971_aw__() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)0.8314f, (float)0.6863f, (float)0.2157f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)l1, (double)(i1 + j1 + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)i2, (double)(i1 + j1 + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)i2, (double)(i1 - 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)l1, (double)(i1 - 2), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)(l1 + 1), (double)(i1 + j1 + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(i2 - 1), (double)(i1 + j1 + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(i2 - 1), (double)(i1 - 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(l1 + 1), (double)(i1 - 1), 0.0).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            boolean flag = this.serverData.field_82821_f != SharedConstants.func_215069_a().getProtocolVersion();
            this.minecraft.field_71466_p.func_238421_b_(matrix, this.serverData.field_78847_a, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 1), 0xFFFFFF);
            List list = this.minecraft.field_71466_p.func_238425_b_((ITextProperties)this.serverData.field_78843_d, p_230432_5_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.field_71466_p.func_238422_b_(matrix, (IReorderingProcessor)list.get(i), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 9 * i), 0x808080);
            }
            ITextComponent itextcomponent1 = flag ? this.serverData.field_82822_g.func_230532_e_().func_240699_a_(TextFormatting.RED) : this.serverData.field_78846_c;
            int j = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)itextcomponent1);
            this.minecraft.field_71466_p.func_243248_b(matrix, itextcomponent1, (float)(p_230432_4_ + p_230432_5_ - j - 15 - 2), (float)(p_230432_3_ + 1), 0x808080);
            int k = 0;
            if (flag) {
                l = 5;
                itextcomponent = INCOMPATIBLE_TOOLTIP;
                list1 = this.serverData.field_147412_i;
            } else if (this.serverData.field_78841_f && this.serverData.field_78844_e != -2L) {
                l = this.serverData.field_78844_e < 0L ? 5 : (this.serverData.field_78844_e < 150L ? 0 : (this.serverData.field_78844_e < 300L ? 1 : (this.serverData.field_78844_e < 600L ? 2 : (this.serverData.field_78844_e < 1000L ? 3 : 4))));
                if (this.serverData.field_78844_e < 0L) {
                    itextcomponent = NO_CONNECTION_TOOLTIP;
                    list1 = Collections.emptyList();
                } else {
                    itextcomponent = new TranslationTextComponent("multiplayer.status.ping", new Object[]{this.serverData.field_78844_e});
                    list1 = this.serverData.field_147412_i;
                }
            } else {
                k = 1;
                l = (int)(Util.func_211177_b() / 100L + (long)(p_230432_2_ * 2) & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                itextcomponent = PINGING_TOOLTIP;
                list1 = Collections.emptyList();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(p_230432_4_ + p_230432_5_ - 15), (int)p_230432_3_, (float)(k * 10), (float)(176 + l * 8), (int)10, (int)8, (int)256, (int)256);
            String s = this.serverData.func_147409_e();
            if (!Objects.equals(s, this.lastIconB64)) {
                if (this.uploadServerIcon(s)) {
                    this.lastIconB64 = s;
                } else {
                    this.serverData.func_147407_a(null);
                    this.updateServerList();
                }
            }
            if (this.icon != null) {
                this.drawIcon(matrix, p_230432_4_, p_230432_3_, this.iconLocation);
            } else {
                this.drawIcon(matrix, p_230432_4_, p_230432_3_, ICON_MISSING);
            }
            i1 = mouseX - p_230432_4_;
            j1 = mouseY - p_230432_3_;
            if (i1 >= p_230432_5_ - 15 && i1 <= p_230432_5_ - 5 && j1 >= 0 && j1 <= 8) {
                this.screen.func_238854_b_(Collections.singletonList(itextcomponent));
            } else if (i1 >= p_230432_5_ - j - 15 - 2 && i1 <= p_230432_5_ - 15 - 2 && j1 >= 0 && j1 <= 8) {
                this.screen.func_238854_b_(list1);
            }
            ClientHooks.drawForgePingInfo((MultiplayerScreen)this.screen, (ServerData)this.serverData, (MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (int)p_230432_5_, (int)i1, (int)j1);
            if (this.minecraft.field_71474_y.field_85185_A || p_230432_9_) {
                this.minecraft.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (int)(p_230432_4_ + 32), (int)(p_230432_3_ + 32), (int)-1601138544);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                k1 = mouseX - p_230432_4_;
                l1 = mouseY - p_230432_3_;
                if (this.canJoin()) {
                    if (k1 < 32 && k1 > 16) {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_230432_2_ > 0) {
                    if (k1 < 16 && l1 < 16) {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)96.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)96.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_230432_2_ < this.screen.getServers().func_78856_c() - 1) {
                    if (k1 < 16 && l1 > 16) {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)p_230432_4_, (int)p_230432_3_, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
            }
        }

        public void updateServerList() {
            this.screen.getServers().func_78855_b();
        }

        protected void drawIcon(MatrixStack p_238859_1_, int p_238859_2_, int p_238859_3_, ResourceLocation p_238859_4_) {
            this.minecraft.func_110434_K().func_110577_a(p_238859_4_);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_((MatrixStack)p_238859_1_, (int)p_238859_2_, (int)p_238859_3_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
        }

        private boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable String p_241614_1_) {
            if (p_241614_1_ == null) {
                this.minecraft.func_110434_K().func_147645_c(this.iconLocation);
                if (this.icon != null && this.icon.func_195414_e() != null) {
                    this.icon.func_195414_e().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.func_216511_b((String)p_241614_1_);
                    Validate.validState((nativeimage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeimage);
                    } else {
                        this.icon.func_195415_a(nativeimage);
                        this.icon.func_110564_a();
                    }
                    this.minecraft.func_110434_K().func_229263_a_(this.iconLocation, (Texture)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.field_78847_a, (Object)this.serverData.field_78845_b, (Object)throwable);
                    return false;
                }
            }
            return true;
        }

        public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
            if (Screen.func_231173_s_()) {
                CustomServerSelectionList serverselectionlist = this.screen.field_146803_h;
                int i = serverselectionlist.func_231039_at__().indexOf((Object)this);
                if (p_231046_1_ == 264 && i < this.screen.getServers().func_78856_c() - 1 || p_231046_1_ == 265 && i > 0) {
                    this.swap(i, p_231046_1_ == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
        }

        private void swap(int p_228196_1_, int p_228196_2_) {
            this.screen.getServers().func_78857_a(p_228196_1_, p_228196_2_);
            this.screen.field_146803_h.updateOnlineServers(this.screen.getServers());
            Entry serverselectionlist$entry = (Entry)((Object)this.screen.field_146803_h.func_231039_at__().get(p_228196_2_));
            this.screen.field_146803_h.setSelected(serverselectionlist$entry);
            CustomServerSelectionList.this.func_230954_d_((AbstractList.AbstractListEntry)serverselectionlist$entry);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int p_231044_5_) {
            if (mouseX < (double)this.list.func_230968_n_()) {
                this.screen.getServers().toggleFavourite(this.serverData);
                this.list.updateOnlineServers(this.screen.getServers());
                this.screen.getServers().func_78855_b();
                return true;
            }
            double d0 = mouseX - (double)CustomServerSelectionList.this.func_230968_n_();
            double d1 = mouseY - (double)CustomServerSelectionList.this.func_230962_i_(CustomServerSelectionList.this.func_231039_at__().indexOf((Object)this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.func_146796_h();
                    return true;
                }
                int i = this.screen.field_146803_h.func_231039_at__().indexOf((Object)this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.swap(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.screen.getServers().func_78856_c() - 1) {
                    this.swap(i, i + 1);
                    return true;
                }
            }
            this.screen.setSelected(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.screen.func_146796_h();
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }

        public CustomServerData getServerData() {
            return this.serverData;
        }
    }

    public class ScrollEntry {
        private int lastValue = 0;
        private int direction = 1;
        private long lastUpdate = System.currentTimeMillis();
        private String currentLine;
        private char currentColour;

        public char getCurrentColour() {
            return this.currentColour;
        }

        public void setCurrentColour(char currentColour) {
            this.currentColour = currentColour;
        }

        public String getCurrentLine() {
            return this.currentLine;
        }

        public void setCurrentLine(String currentLine) {
            this.currentLine = currentLine;
        }

        public int getLastValue() {
            return this.lastValue;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setLastValue(int lastValue) {
            this.lastValue = lastValue;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public boolean shouldUpdate() {
            return System.currentTimeMillis() - this.lastUpdate >= 100L;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanScanEntry
    extends Entry {
        private final Minecraft minecraft = Minecraft.func_71410_x();

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            String s;
            int i = p_230432_3_ + p_230432_6_ / 2 - 4;
            this.minecraft.field_71466_p.func_243248_b(p_230432_1_, SCANNING_LABEL, (float)(this.minecraft.field_71462_r.field_230708_k_ / 2 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)SCANNING_LABEL) / 2), (float)i, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.minecraft.field_71466_p.func_238421_b_(p_230432_1_, s, (float)(this.minecraft.field_71462_r.field_230708_k_ / 2 - this.minecraft.field_71466_p.func_78256_a(s) / 2), (float)(i + 9), 0x808080);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanDetectedEntry
    extends Entry {
        private static final ITextComponent LAN_SERVER_HEADER = new TranslationTextComponent("lanServer.title");
        private static final ITextComponent HIDDEN_ADDRESS_TEXT = new TranslationTextComponent("selectServer.hiddenAddress");
        private final CustomMultiplayerScreen screen;
        protected final Minecraft minecraft;
        protected final LanServerInfo serverData;
        private long lastClickTime;

        protected LanDetectedEntry(CustomMultiplayerScreen p_i47141_1_, LanServerInfo p_i47141_2_) {
            this.screen = p_i47141_1_;
            this.serverData = p_i47141_2_;
            this.minecraft = Minecraft.func_71410_x();
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.minecraft.field_71466_p.func_243248_b(p_230432_1_, LAN_SERVER_HEADER, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 1), 0xFFFFFF);
            this.minecraft.field_71466_p.func_238421_b_(p_230432_1_, this.serverData.func_77487_a(), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12), 0x808080);
            if (this.minecraft.field_71474_y.field_80005_w) {
                this.minecraft.field_71466_p.func_243248_b(p_230432_1_, HIDDEN_ADDRESS_TEXT, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 11), 0x303030);
            } else {
                this.minecraft.field_71466_p.func_238421_b_(p_230432_1_, this.serverData.func_77488_b(), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 11), 0x303030);
            }
        }

        public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
            this.screen.setSelected(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.screen.func_146796_h();
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }

        public LanServerInfo getServerData() {
            return this.serverData;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
    }
}

