/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.BubbleObject;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogScreen;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FishingLogInformationScreen
extends Screen {
    private Pokemon pokemon;
    private int[] encountered;
    private int category;
    private double scalar = 10900.0;
    private PixelmonEntity displayedPokemon;
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private Button okButton;
    private List<BubbleObject> bubbles = Lists.newArrayList();

    public FishingLogInformationScreen(int dex, int category, int form, int ... data) {
        super(StringTextComponent.field_240750_d_);
        this.category = category;
        Species species = PixelmonSpecies.fromNationalDex(dex);
        PokemonSpecification spec = FormLogRegistry.getFormFromId(species, form);
        this.pokemon = PokemonFactory.create(species);
        spec.apply(this.pokemon);
        this.encountered = Arrays.copyOfRange(data, 3, data.length);
    }

    public FishingLogInformationScreen(int dex, int category, PokemonSpecification form, int[] data) {
        super(StringTextComponent.field_240750_d_);
        this.category = category;
        Species species = PixelmonSpecies.fromNationalDex(dex);
        this.pokemon = PokemonFactory.create(species);
        form.apply(this.pokemon);
        this.encountered = data;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        int height = 20;
        int width = (int)((double)height * 5.338235294117647);
        this.okButton = (Button)this.func_230480_a_((Widget)new Button(this.centerX - width / 2, this.centerY + 70, width, height, StringTextComponent.field_240750_d_, this::actionPerformed));
        this.bubbles = Lists.newArrayList();
        this.setupDisplayedPokemon();
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.getFontRenderer("pixelmon:textures/gui/pokemonfont.png", true);
        if (this.bubbles.size() < 8 && RandomHelper.getRandomChance(0.05)) {
            int size = RandomHelper.getRandomNumberBetween(5, 10);
            this.bubbles.add(new BubbleObject(this.centerX + RandomHelper.getRandomNumberBetween(-65, 65 - size), this.centerY, size));
        }
        this.func_230446_a_(matrix);
        this.drawScreenForeground(matrix, mouseX, mouseY, partialTicks);
    }

    public void func_230446_a_(MatrixStack matrix) {
        float borderWidth = 1.0f;
        float width = this.guiWidth - borderWidth * 2.0f;
        ScreenHelper.drawImageQuad(Resources.fishingLogWater, matrix, (float)this.centerX - this.guiWidth / 2.0f + borderWidth, (float)this.centerY - this.guiHeight / 2.0f + borderWidth, width, width * 0.73f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227860_a_();
        float sf = (float)this.field_230706_i_.func_228018_at_().func_198100_s();
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * sf;
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * sf;
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 1.0f) * sf;
        float y2 = (float)this.centerY * sf;
        GL11.glScissor((int)((int)x1), (int)((int)((float)this.field_230706_i_.func_228018_at_().func_198083_n() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        for (int i = 0; i < this.bubbles.size(); ++i) {
            BubbleObject bubble = this.bubbles.get(i);
            bubble.render(matrix);
            if (!(bubble.getY() < (float)this.centerY - this.guiHeight / 2.0f - 20.0f)) continue;
            this.bubbles.remove(i--);
        }
        GL11.glDisable((int)3089);
        matrix.func_227865_b_();
        ScreenHelper.drawImageQuad(Resources.fishingLogInformationBackground, matrix, (float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawScreenForeground(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.fishingLogConfirmButton, matrix, this.okButton.field_230690_l_, this.okButton.field_230691_m_, this.okButton.func_230998_h_(), this.okButton.func_238483_d_(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawCenteredString(matrix, "Ok", (float)this.centerX, (float)(this.okButton.field_230691_m_ + 6), this.okButton.func_231047_b_((double)mouseX, (double)mouseY) ? -12687348 : -1);
        if (this.pokemon.getForm().isForm(PixelmonForms.NONE) && this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)"pixelmon.generic.form.base", (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(matrix, I18n.func_135052_a((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".palette." + this.pokemon.getPalette().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        } else if (!this.pokemon.getForm().isForm(PixelmonForms.NONE) && this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".form." + this.pokemon.getForm().getName()), (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(matrix, I18n.func_135052_a((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".form." + this.pokemon.getForm().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        } else if (!this.pokemon.getPalette().is("none")) {
            ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)("pixelmon.palette." + this.pokemon.getPalette().getName()), (Object[])new Object[0]), this.centerX, this.centerY + 1, -7781367, 14.0f);
            ScreenHelper.drawScaledCenteredSplitString(matrix, I18n.func_135052_a((String)("pixelmon." + this.pokemon.getSpecies().getName().toLowerCase() + ".palette." + this.pokemon.getPalette().getName() + ".description"), (Object[])new Object[0]), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        }
        this.drawEntityToScreen(matrix, this.centerX, this.centerY - 30, 70, this.displayedPokemon, mouseX, partialTicks);
    }

    protected void actionPerformed(Button button) {
        if (button != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FishingLogScreen(this.pokemon.getSpecies().getDex(), this.encountered));
        }
    }

    private void setupDisplayedPokemon() {
        if (this.field_230706_i_ == null) {
            return;
        }
        this.displayedPokemon = new PixelmonEntity((World)this.field_230706_i_.field_71441_e, this.pokemon);
        this.displayedPokemon.func_70107_b(this.field_230706_i_.field_71439_g.func_226277_ct_(), this.field_230706_i_.field_71439_g.func_226278_cu_(), this.field_230706_i_.field_71439_g.func_226281_cx_());
        this.displayedPokemon.getPokemon().setGrowth(EnumGrowth.Ordinary);
        this.displayedPokemon.setDisableNametag(true);
        this.displayedPokemon.checkAnimation();
        this.displayedPokemon.setAnimation(AnimationType.SWIM);
        this.displayedPokemon.initAnimation();
        double referenceW = 50.0;
        double referenceH = 50.0;
        double dh = (double)this.displayedPokemon.func_213302_cg() - referenceH;
        double dw = (double)this.displayedPokemon.func_213311_cf() - referenceW;
        this.scalar = dh > dw ? referenceH / (double)this.displayedPokemon.func_213302_cg() : referenceW / (double)this.displayedPokemon.func_213311_cf();
    }

    public void func_231023_e_() {
        if (this.displayedPokemon != null && this.displayedPokemon.getAnimationVariables() != null) {
            this.displayedPokemon.getAnimationVariables().tick();
        }
    }

    private void drawEntityToScreen(MatrixStack matrix, int x, int y, int l, PixelmonEntity entity, int mouseX, float partialTicks) {
        matrix.func_227860_a_();
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        matrix.func_227861_a_((double)x, (double)y, 100.0);
        matrix.func_227862_a_((float)this.scalar, (float)this.scalar, (float)this.scalar);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler((float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        PixelmonRendering.renderEntity(matrix, entity, true, partialTicks);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(360.0f - (float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.func_227862_a_(1.0f / (float)this.scalar, 1.0f / (float)this.scalar, 1.0f / (float)this.scalar);
        matrix.func_227865_b_();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!super.func_231043_a_(mouseX, mouseY, delta)) {
            this.scalar += delta;
        }
        return true;
    }
}

