/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.daycare;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareContainer;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareSlot;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryPixelmonBase;
import com.pixelmonmod.pixelmon.client.gui.widgets.InvisibleButtonWithTooltip;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.AddToDayCarePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.CancelDayCareBoxPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.CompleteDayCareRequirementPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareHourglassUsedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestAllErrorsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestConditionUpdatePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.RequestDayCareChildPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.WithdrawDayCareBoxPacket;
import com.pixelmonmod.pixelmon.items.IsiHourglassItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.AirItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DayCareScreen
extends DisplayEffectsScreen<DayCareContainer>
implements InventoryPixelmonBase {
    private static final ResourceLocation GUI_LOCATION = ResourceLocationHelper.of("pixelmon", "textures/gui/daycare/inventory.png");
    private static final ResourceLocation OVAL_CHARM_ITEM = ResourceLocationHelper.of("pixelmon", "textures/items/keyitems/oval_charm.png");
    public static final DayCareSlot[] SLOTS = new DayCareSlot[]{new DayCareSlot(15.0, 46.5, 16.0, 16.0), new DayCareSlot(35.0, 46.5, 16.0, 16.0)};
    private InventoryPixelmon<?> inventory;
    private PlayerPartyStorage party;
    private DayCareBox box;
    private int[] slots = new int[]{-1, -1};
    private int selectedSlot = -1;
    private Pokemon child;
    private Pokemon displayedChild;
    private int startSlot = 0;

    public DayCareScreen(DayCareContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.party = ClientStorageManager.party;
        this.inventory = new InventoryPixelmon<DayCareScreen>(this, 42);
        this.selectBox(0, false);
    }

    public void func_231160_c_() {
        int boxId;
        super.func_231160_c_();
        this.inventory.initGui();
        this.func_230480_a_((Widget)new InvisibleButtonWithTooltip(this.getGuiLeft() + 13, this.getGuiTop() + 45 + 16 + 5, 16, 16, StringTextComponent.field_240750_d_, this::clickCancel, (a, matrix, mouseX, mouseY) -> this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.cancel"), mouseX, mouseY), i -> this.box != null && !this.box.isEmpty(), 0));
        this.func_230480_a_((Widget)new InvisibleButtonWithTooltip(this.getGuiLeft() + 13 + 16 + 3, this.getGuiTop() + 45 + 16 + 3, 19, 19, StringTextComponent.field_240750_d_, this::clickConfirm, (a, matrix, mouseX, mouseY) -> this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.confirm"), mouseX, mouseY), i -> this.box != null && this.child != null && this.box.isEmpty() || this.box != null && !this.box.hasBreedingBegun() && this.box.canConsume(), 0));
        Predicate<Integer> previousPredicate = i -> i > 0;
        this.func_230480_a_((Widget)new InvisibleButtonWithTooltip(this.getGuiLeft() + this.field_146999_f - 16 - 16 - 10, this.getGuiTop(), 16, 14, StringTextComponent.field_240750_d_, button -> this.swapPage(false), (a, matrix, mouseX, mouseY) -> this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.previous.page"), mouseX, mouseY), previousPredicate, this.startSlot));
        Predicate<Integer> nextPredicate = i -> i < this.party.getDayCare().getAllowedBoxes();
        this.func_230480_a_((Widget)new InvisibleButtonWithTooltip(this.getGuiLeft() + this.field_146999_f - 16 - 10, this.getGuiTop(), 16, 14, StringTextComponent.field_240750_d_, button -> this.swapPage(true), (a, matrix, mouseX, mouseY) -> this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.next.page"), mouseX, mouseY), nextPredicate, this.startSlot + 3));
        int i2 = (this.field_230708_k_ - 176) / 2;
        int j = (this.field_230709_l_ - 166) / 2;
        int j1 = i2 + 60;
        PlayerDayCare dayCare = ClientStorageManager.party.getDayCare();
        for (int k = 0; k < 3 && (boxId = this.startSlot + k) < this.party.getDayCare().getAllowedBoxes(); ++k) {
            int finalK = k;
            this.func_230480_a_((Widget)new InvisibleButtonWithTooltip(j1, j + 14 + 19 * k, 108, 19, StringTextComponent.field_240750_d_, button -> this.selectBox(this.startSlot + finalK, true), (a, matrix, mouseX, mouseY) -> {
                Optional<DayCareBox> box = dayCare.getOrCreateBox(boxId);
                box.ifPresent(dayCareBox -> {
                    if (dayCareBox.canBreedingBegin() || dayCareBox.isEmpty()) {
                        this.renderWrappedToolTip(matrix, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId)}), mouseX, mouseY, this.field_230712_o_);
                        return;
                    }
                    if (dayCareBox.getAllErrorMessages() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestAllErrorsPacket(dayCareBox.getBoxId()));
                        this.renderWrappedToolTip(matrix, Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId)}), mouseX, mouseY, this.field_230712_o_);
                        return;
                    }
                    ArrayList allErrorMessages = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId), new TranslationTextComponent("pixelmon.daycare.requirements")});
                    allErrorMessages.addAll(dayCareBox.getAllErrorMessages());
                    this.renderWrappedToolTip(matrix, allErrorMessages, mouseX, mouseY, this.field_230712_o_);
                });
            }));
        }
    }

    private void clickConfirm(Button button) {
        if (this.box == null || this.box.hasBreedingBegun() && this.box.getPercentComplete() < 100.0) {
            return;
        }
        if (!this.box.isEmpty() && this.box.hasBreedingBegun() && this.box.getPercentComplete() >= 100.0) {
            NetworkHelper.sendToServer(new WithdrawDayCareBoxPacket(this.box.getBoxId()));
            ScreenHelper.closeScreen();
            return;
        }
        if (!this.box.isEmpty() && !this.box.canBreedingBegin() && this.box.canConsume()) {
            NetworkHelper.sendToServer(new CompleteDayCareRequirementPacket(this.box.getBoxId()));
            return;
        }
        if (this.child == null) {
            return;
        }
        NetworkHelper.sendToServer(new AddToDayCarePacket(this.box.getBoxId(), this.slots[0], this.slots[1]));
    }

    private void clickCancel(Button button) {
        if (this.box == null) {
            return;
        }
        if (!this.box.isEmpty() && this.box.hasBreedingBegun() && this.box.getPercentComplete() >= 100.0) {
            NetworkHelper.sendToServer(new WithdrawDayCareBoxPacket(this.box.getBoxId()));
            ScreenHelper.closeScreen();
            return;
        }
        NetworkHelper.sendToServer(new CancelDayCareBoxPacket(this.box.getBoxId()));
        ScreenHelper.closeScreen();
    }

    private void selectBox(int boxId, boolean checkHeld) {
        if (checkHeld && this.field_230706_i_ != null && !(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof AirItem)) {
            ItemStack carried = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
            if (!(carried.func_77973_b() instanceof IsiHourglassItem)) {
                return;
            }
            NetworkHelper.sendToServer(new DayCareHourglassUsedPacket(boxId - this.startSlot, this.startSlot, this.startSlot + 1, this.startSlot + 2));
            return;
        }
        DayCareBox dayCareBox = this.party.getDayCare().getOrCreateBox(boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty()) {
            this.setBox(this.party.getDayCare().getFirstEmptyBox());
        } else {
            this.setBox(dayCareBox);
            if (!dayCareBox.canBreedingBegin()) {
                NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(dayCareBox.getBoxId()));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.pixelmonOverlayExtended2);
        this.func_238474_b_(matrix, this.field_147003_i - 80, this.field_230709_l_ / 2 - 83, 0, 0, 90, 166);
        this.inventory.drawGuiContainerBackgroundLayer(matrix, partialTicks, mouseX, mouseY);
        this.inventory.render(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        matrix.func_227860_a_();
        this.func_230459_a_(matrix, mouseX, mouseY);
        ScreenHelper.drawInUnicode(() -> {
            this.renderSlots(matrix, mouseX, mouseY);
            if (this.child != null && this.box != null && this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.displayedChild.getSprite(), matrix, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (this.box != null && !this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getEgg().getSprite(), matrix, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (this.startSlot > 0) {
                ScreenHelper.drawImageQuad(Resources.UP, matrix, this.getGuiLeft() + this.field_146999_f - 16 - 16 - 10, this.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, this.getZLevel());
            }
            if (this.startSlot < this.party.getDayCare().getAllowedBoxes() - 3) {
                ScreenHelper.drawImageQuad(Resources.DOWN, matrix, this.getGuiLeft() + this.field_146999_f - 16 - 10, this.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, this.getZLevel());
            }
            this.field_230706_i_.field_71466_p.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.title"), (float)(this.getGuiLeft() + 5), (float)(this.getGuiTop() + 3), 1);
        });
        matrix.func_227865_b_();
    }

    private void renderSlots(MatrixStack matrix, double mouseX, double mouseY) {
        int id = 0;
        boolean full = ClientStorageManager.party.getDayCare().isFull();
        for (int slot : this.slots) {
            DayCareSlot slotData = SLOTS[id];
            if (full && this.box == null) {
                ScreenHelper.drawImageQuad(Resources.NO_ENTRY, matrix, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                ++id;
                continue;
            }
            if (!this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getParent(id + 1).getSprite(), matrix, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
                if (slotData.inSlot(mouseX - (double)this.getGUILeft(), mouseY - (double)this.getGuiTop())) {
                    ScreenHelper.drawPokemonHoverInfo(matrix, this.box.getParent(id + 1), (int)mouseX, (int)mouseY);
                }
                ++id;
                continue;
            }
            if (slot == -1) {
                ++id;
                continue;
            }
            Pokemon pokemon = ClientStorageManager.party.get(slot);
            if (pokemon == null || pokemon.isUnbreedable()) {
                this.slots[id] = -1;
                ++id;
                continue;
            }
            if (this.selectedSlot == id) {
                ScreenHelper.drawImageQuadUV(Resources.pcResources, matrix, (float)this.getGuiLeft() + (float)slotData.getStartX() - 0.25f, (float)this.getGuiTop() + (float)slotData.getStartY() + 0.25f, (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 29.0f, 29.0f, 29.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
            if (slotData.inSlot(mouseX - (double)this.getGUILeft(), mouseY - (double)this.getGuiTop())) {
                ScreenHelper.drawPokemonHoverInfo(matrix, pokemon, (int)mouseX, (int)mouseY);
            }
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            ++id;
        }
    }

    public boolean func_231044_a_(double x, double y, int mouseButton) {
        if (this.inventory.mouseClicked(x, y, mouseButton) && this.isOutsideParty(x, y)) {
            if (this.party.getDayCare().isFull() || !this.box.isEmpty()) {
                return super.func_231044_a_(x, y, mouseButton);
            }
            double mouseX = x - (double)this.getGUILeft();
            double mouseY = y - (double)this.getGuiTop();
            if (this.inventory.getSelected() == null) {
                if (this.selectedSlot == -1) {
                    for (int i = 0; i < this.slots.length; ++i) {
                        if (!SLOTS[i].inSlot(mouseX, mouseY)) continue;
                        this.selectedSlot = i;
                        this.inventory.setSelected(null);
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.slots.length; ++i) {
                        if (this.selectedSlot == i && SLOTS[i].inSlot(mouseX, mouseY)) {
                            this.selectedSlot = -1;
                            continue;
                        }
                        if (!SLOTS[i].inSlot(mouseX, mouseY) || this.selectedSlot == -1) continue;
                        int swapSlotValue = this.slots[this.selectedSlot];
                        this.slots[this.selectedSlot] = this.slots[i];
                        this.slots[i] = swapSlotValue;
                        this.selectedSlot = -1;
                    }
                }
            } else {
                if (ClientStorageManager.party.countPokemon() <= 2) {
                    return true;
                }
                Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
                if (pokemon == null || pokemon.isEgg() || pokemon.isFainted() || pokemon.isUnbreedable()) {
                    return true;
                }
                for (int i = 0; i < this.slots.length; ++i) {
                    if (!SLOTS[i].inSlot(mouseX, mouseY)) continue;
                    this.setSlot(i);
                }
            }
            this.checkAndGetChild();
            return super.func_231044_a_(x, y, mouseButton);
        }
        if (ClientStorageManager.party.countPokemon() <= 2) {
            return true;
        }
        if (this.inventory.getSelected() == null) {
            this.checkAndGetChild();
            return true;
        }
        Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
        if (pokemon == null || pokemon.isEgg() || pokemon.isFainted() || pokemon.isUnbreedable()) {
            return true;
        }
        if (this.inventory.getSelected() != null && this.selectedSlot != -1) {
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.selectedSlot != i) continue;
                this.setSlot(i);
            }
        }
        return true;
    }

    private void setSlot(int slotId) {
        Pokemon pokemon = ClientStorageManager.party.get(this.inventory.getSelected().order);
        if (pokemon.isUnbreedable()) {
            this.inventory.setSelected(null);
            return;
        }
        if (this.getOtherSlot(slotId) == this.inventory.getSelected().order) {
            this.inventory.setSelected(null);
            return;
        }
        this.selectedSlot = -1;
        this.slots[slotId] = this.inventory.getSelected().order;
        this.inventory.setSelected(null);
        this.checkAndGetChild();
    }

    private int getOtherSlot(int slotId) {
        return this.slots[(slotId + 1) % this.slots.length];
    }

    private void checkAndGetChild() {
        if (this.isASlotUnset()) {
            return;
        }
        if (this.clearFaintedSlots()) {
            return;
        }
        NetworkHelper.sendToServer(new RequestDayCareChildPacket(this.slots[0], this.slots[1]));
    }

    private boolean isASlotUnset() {
        for (int slot : this.slots) {
            if (slot != -1) continue;
            return true;
        }
        return false;
    }

    private boolean clearFaintedSlots() {
        for (int partySlot : this.slots) {
            if (this.party.get(partySlot) == null || !this.party.get(partySlot).isFainted()) continue;
            this.setBox(this.box);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.isOutsideParty(mouseX, mouseY)) {
            return super.func_231048_c_(mouseX, mouseY, button);
        }
        return false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.inventory.tick();
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawInUnicode(() -> {
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
            int i = (this.field_230708_k_ - 176) / 2;
            int j = (this.field_230709_l_ - 166) / 2;
            this.func_238474_b_(matrix, i, j, 0, 0, 176, 166);
            int j1 = i + 60;
            if (this.child != null && this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(Resources.TICK, matrix, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 64, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
            }
            if (this.box != null && !this.box.isEmpty()) {
                if (!this.box.hasBreedingBegun()) {
                    if (!this.box.canConsume()) {
                        ScreenHelper.drawImageQuad(Resources.NO_ENTRY, matrix, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                    } else {
                        ScreenHelper.drawImageQuad(Resources.TICK, matrix, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
                    }
                }
                if (this.box.getPercentComplete() < 100.0) {
                    ScreenHelper.drawImageQuad(Resources.CROSS, matrix, this.getGuiLeft() + 13 + 2, this.getGuiTop() + 65, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, this.getZLevel());
                }
            }
            for (int k = 0; k < 3; ++k) {
                int boxId = this.startSlot + k;
                if (boxId >= this.party.getDayCare().getAllowedBoxes()) {
                    this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
                    this.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 0, 186, 108, 19);
                    continue;
                }
                DayCareBox box = this.party.getDayCare().getOrCreateBox(boxId).orElse(null);
                if (box == null) continue;
                if (!box.canBreedingBegin() && !box.isEmpty()) {
                    if (box.getErrorMessage() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(box.getBoxId()));
                        continue;
                    }
                    this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
                    this.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 109, 205, 109, 19);
                    this.field_230706_i_.field_71466_p.func_243248_b(matrix, box.getErrorMessage(), (float)(j1 + 20), (float)(j + 19 + 19 * k), 1);
                } else if (!box.isEmpty() && box.hasBreedingBegun()) {
                    if (box.getPercentComplete() < 100.0) {
                        this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
                        this.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 0, 205, 109, 19);
                        this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
                        this.func_238474_b_(matrix, j1 - 1 + 23, j + 19 + 19 * k, 19, 226, 81, 5);
                        this.func_238474_b_(matrix, j1 - 1 + 23, j + 19 + 19 * k, 19, 231, (int)(box.getPercentComplete() / 100.0 * 81.0), 5);
                        ITextComponent totalDuration = StringHelper.getFormattedDuration(box.getTotalDuration());
                        if (box.getOvalCharmActive()) {
                            FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
                            float f = (float)(j1 + 18 + 50) - (float)this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)totalDuration) * 1.5f;
                            this.field_230706_i_.field_71466_p.getClass();
                            fontRenderer.func_243248_b(matrix, totalDuration, f, (float)(j + 33 + 19 * k - 9), 1);
                            float f2 = j1 + 18 + 50 - 4;
                            this.field_230706_i_.field_71466_p.getClass();
                            ScreenHelper.drawImageQuad(OVAL_CHARM_ITEM, matrix, f2, j + 33 + 19 * k - 9, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
                        } else {
                            FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
                            float f = j1 + 18 + 50 - this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)totalDuration);
                            this.field_230706_i_.field_71466_p.getClass();
                            fontRenderer.func_243248_b(matrix, totalDuration, f, (float)(j + 33 + 19 * k - 9), 1);
                        }
                    } else {
                        ScreenHelper.drawImageQuad(Resources.TICK, matrix, this.getGuiLeft() + 13 + 16 + 3 + 2, this.getGuiTop() + 64, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, this.getZLevel());
                        this.field_230706_i_.func_110434_K().func_110577_a(GUI_LOCATION);
                        this.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 109, 186, 109, 19);
                        TranslationTextComponent complete = new TranslationTextComponent("pixelmon.daycare.complete");
                        this.field_230706_i_.field_71466_p.func_243248_b(matrix, (ITextComponent)complete, (float)(j1 + 18 + 45 - this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)complete) / 2), (float)(j + 18 + 19 * k), 1);
                    }
                }
                if (box.isEmpty()) continue;
                ScreenHelper.drawImageQuad(box.getEgg().getSprite(), matrix, j1, j + 13 + 19 * k, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, this.getZLevel());
            }
        });
    }

    private void swapPage(boolean forward) {
        if (this.startSlot == 0 && !forward) {
            return;
        }
        if (this.startSlot == this.party.getDayCare().getAllowedBoxes() - 3 && forward) {
            return;
        }
        this.startSlot += forward ? 1 : -1;
        this.field_230710_m_.clear();
        this.func_231160_c_();
    }

    public void setChild(Pokemon child, boolean showPotentialShiny) {
        this.child = child;
        this.displayedChild = PokemonFactory.copy(child);
        boolean isShiny = child.isShiny();
        if (!showPotentialShiny && isShiny) {
            this.displayedChild.setShiny(false);
        }
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public float getZLevel() {
        return 1.0f;
    }

    @Override
    public int getGUILeft() {
        return (this.field_230708_k_ - 176) / 2;
    }

    @Override
    public void offsetGUILeft(int offset) {
        this.field_147003_i += offset;
    }

    @Override
    public List<Widget> getButtonList() {
        return this.field_230710_m_;
    }

    @Override
    public void refreshSearchResults() {
    }

    private boolean isOutsideParty(double x, double y) {
        return !this.isWithinParty(x, y) && !this.isWithinLoreBox(x, y);
    }

    private boolean isWithinParty(double x, double y) {
        int centerW = this.field_230708_k_ / 2;
        int centerH = this.field_230709_l_ / 2;
        return x > (double)(centerW + -128) && x < (double)(centerW + -80) && y > (double)(centerH + -84) && y < (double)(centerH + 60);
    }

    private boolean isWithinLoreBox(double x, double y) {
        int centerW = this.field_230708_k_ / 2;
        int centerH = this.field_230709_l_ / 2;
        return x > (double)(centerW + -168) && x < (double)(centerW + -128) && y > (double)(centerH + -84) && y < (double)(centerH + -42);
    }

    public void setAndSelectBox(DayCareBox box) {
        this.box = box;
        this.slots = new int[]{-1, -1};
        this.child = null;
        this.displayedChild = null;
        this.selectBox(box.getBoxId(), false);
    }

    public void setBox(DayCareBox box) {
        this.box = box;
        this.slots = new int[]{-1, -1};
        this.child = null;
        this.displayedChild = null;
    }

    public void func_238811_b_(MatrixStack matrix) {
    }

    protected void func_175378_g() {
    }
}

