/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.custom.overlays;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.OverlayGraphicType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CustomNoticeOverlay {
    private static boolean enabled = false;
    private static Collection<ITextComponent> lines;
    private static OverlayGraphicType type;
    private static EnumOverlayLayout layout;
    private static int squareSize;
    private static Pokemon pokemon;
    private static PixelmonEntity entity;
    private static float scale;
    private static ItemStack itemStack;

    public static void resetNotice() {
        enabled = false;
        lines = null;
        type = null;
        layout = null;
        pokemon = null;
        entity = null;
        itemStack = null;
    }

    public static void draw(MatrixStack matrix) {
        Minecraft mc = Minecraft.func_71410_x();
        Optional<int[]> coordsOptional = ScreenHelper.renderTooltip(matrix, mc.func_228018_at_().func_198107_o() / 2, 15, lines, -16776961, -1, 100, true, true, 0.0f);
        if (coordsOptional.isPresent()) {
            int[] coords = coordsOptional.get();
            if (type != null) {
                switch (type) {
                    case PokemonSprite: {
                        CustomNoticeOverlay.drawPokemonSprites(matrix, coords);
                        break;
                    }
                    case Pokemon3D: {
                        CustomNoticeOverlay.drawPokemon3Ds(matrix, coords);
                        break;
                    }
                    case ItemStack: {
                        CustomNoticeOverlay.drawItemStacks(coords);
                    }
                }
            }
        }
    }

    public static void setEnabled(boolean enabled) {
        CustomNoticeOverlay.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void populate(List<ITextComponent> lines) {
        CustomNoticeOverlay.lines = lines;
    }

    public static void setPokemonSprite(PokemonSpecification spec, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.PokemonSprite;
        pokemon = spec.create();
        if (pokemon == null) {
            throw new IllegalArgumentException(String.format("The spec '%s' is not valid.", spec.toString()));
        }
    }

    public static void setPokemon3D(PokemonSpecification spec, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.Pokemon3D;
        entity = spec.create((World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("The spec '%s' is not valid.", spec.toString()));
        }
        scale = 15.0f / entity.func_213302_cg();
    }

    public static void setItemStack(ItemStack itemStack, EnumOverlayLayout layout) {
        CustomNoticeOverlay.layout = layout;
        type = OverlayGraphicType.ItemStack;
        CustomNoticeOverlay.itemStack = itemStack;
    }

    private static void drawPokemonSprites(MatrixStack matrix, int[] coords) {
        ResourceLocation rl = pokemon.getSprite();
        switch (layout) {
            case LEFT: {
                ScreenHelper.drawImageQuad(rl, matrix, coords[0] - squareSize, 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case RIGHT: {
                ScreenHelper.drawImageQuad(rl, matrix, coords[2], 0.0f, squareSize, squareSize, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                break;
            }
            case LEFT_AND_RIGHT: {
                ScreenHelper.drawImageQuad(rl, matrix, coords[0] - squareSize, 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuad(rl, matrix, coords[2], 0.0f, squareSize, squareSize, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    private static void drawPokemon3Ds(MatrixStack matrix, int[] coords) {
        switch (layout) {
            case LEFT: {
                ScreenHelper.drawEntity(matrix, (LivingEntity)entity, coords[0] - 15, squareSize - 5, scale, -60.0f, 0.0f);
                break;
            }
            case RIGHT: {
                ScreenHelper.drawEntity(matrix, (LivingEntity)entity, coords[2] + 15, squareSize - 5, scale, 60.0f, 0.0f);
                break;
            }
            case LEFT_AND_RIGHT: {
                ScreenHelper.drawEntity(matrix, (LivingEntity)entity, coords[0] - 15, squareSize - 5, scale, -60.0f, 0.0f);
                ScreenHelper.drawEntity(matrix, (LivingEntity)entity, coords[2] + 15, squareSize - 5, scale, 60.0f, 0.0f);
            }
        }
    }

    private static void drawItemStacks(int[] coords) {
        RenderHelper.func_227780_a_();
        RenderSystem.enableDepthTest();
        ItemRenderer ri = Minecraft.func_71410_x().func_175599_af();
        switch (layout) {
            case LEFT: {
                ri.func_180450_b(itemStack, coords[0] - 20, 15);
                break;
            }
            case RIGHT: {
                ri.func_180450_b(itemStack, coords[2] + 5, 15);
                break;
            }
            case LEFT_AND_RIGHT: {
                ri.func_180450_b(itemStack, coords[0] - 20, 15);
                ri.func_180450_b(itemStack, coords[2] + 5, 15);
            }
        }
        RenderSystem.disableDepthTest();
    }

    static {
        squareSize = 40;
        scale = 1.0f;
    }
}

