/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleMenuScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.screens.bag.ItemMenuButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BagPacket;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ChooseBag
extends BattleMenuScreen<ItemMenuButton> {
    private final List<ItemMenuButton> BUTTONS = Lists.newArrayList();

    public ChooseBag(BattleScreen parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.BUTTONS.isEmpty()) {
            this.BUTTONS.add(new ItemMenuButton(0, new ItemStack((IItemProvider)PixelmonItems.poke_ball), BagSection.POKEBALLS.getLocalizedName(), (Screen)this));
            this.BUTTONS.add(new ItemMenuButton(1, new ItemStack((IItemProvider)PixelmonItems.potion), BagSection.HP.getLocalizedName(), (Screen)this));
            this.BUTTONS.add(new ItemMenuButton(2, new ItemStack((IItemProvider)PixelmonItems.x_attack), BagSection.BATTLE_ITEMS.getLocalizedName(), (Screen)this));
            this.BUTTONS.add(new ItemMenuButton(3, new ItemStack((IItemProvider)PixelmonItems.full_restore), BagSection.STATUS_RESTORE.getLocalizedName(), (Screen)this));
        }
        this.bm.bagSection = null;
    }

    @Override
    public ITextComponent func_231171_q_() {
        return this.bm.bagSection == null ? new TranslationTextComponent("gui.mainmenu.bag") : new StringTextComponent(this.bm.bagSection.getLocalizedName());
    }

    @Override
    public List<ItemMenuButton> generateButtons() {
        if (this.bm.getLastUsedItemIfStillAvailable().isPresent()) {
            ItemStack stack = this.bm.getLastUsedItemIfStillAvailable().get().getItemStack();
            this.menuElement.setReuseMessage("gui.choosebag.lastitem", stack);
        }
        if (this.bm.bagSection == null) {
            return this.BUTTONS;
        }
        ArrayList list = Lists.newArrayList();
        List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
        int index = 0;
        for (ItemData entry : bag) {
            list.add(new ItemMenuButton(index++, entry.getItemStack(), entry.getItemStack().func_190916_E(), (Screen)this));
        }
        return list;
    }

    @Override
    public void render(MatrixStack matrix, int width, int height, int mouseX, int mouseY, float partialTicks) {
        super.render(matrix, width, height, mouseX, mouseY, partialTicks);
    }

    @Override
    public void click(int width, int height, double mouseX, double mouseY) {
        if (this.menuElement.isMouseOver(mouseX, mouseY)) {
            if (this.menuElement.isOverReturnButton(mouseX, mouseY)) {
                if (this.bm.bagSection == null) {
                    this.bm.setMode(BattleMode.MAIN_MENU);
                } else {
                    this.bm.bagSection = null;
                }
            } else if (this.menuElement.isOverReuseButton(mouseX, mouseY)) {
                this.bm.bagSection = (BagSection)this.bm.lastItem.getKey();
                this.bm.itemToUse = (ItemData)this.bm.lastItem.getValue();
                if (this.bm.bagSection == BagSection.POKEBALLS) {
                    this.bm.selectedActions.clear();
                    NetworkHelper.sendToServer(new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, this.bm.itemToUse.getItemStack(), this.bm.battleControllerIndex, 0));
                    this.bm.setMode(BattleMode.WAITING);
                } else {
                    this.bm.setMode(BattleMode.APPLY_TO_POKEMON);
                }
            } else if (!this.menuElement.handleClickPageTurn(mouseX, mouseY)) {
                List buttons = this.menuElement.getPageButtons();
                for (ItemMenuButton button : buttons) {
                    if (!button.func_231044_a_(mouseX, mouseY, 0)) continue;
                    if (this.bm.bagSection == null) {
                        BagSection bs = BagSection.getSection(button.id);
                        if (bs == BagSection.POKEBALLS) {
                            if (!this.bm.canCatchOpponent()) {
                                this.bm.addMessage(I18n.func_135052_a((String)"gui.choosebag.nopokeballs", (Object[])new Object[0]));
                                this.bm.setMode(BattleMode.MAIN_MENU);
                                break;
                            }
                            if (Arrays.stream(this.bm.displayedEnemyPokemon).filter(p -> p.health.get() > 0.0).count() > 1L) {
                                this.bm.addMessage(I18n.func_135052_a((String)"gui.choosebag.multiple", (Object[])new Object[0]));
                                this.bm.setMode(BattleMode.MAIN_MENU);
                                break;
                            }
                        }
                        this.bm.bagSection = BagSection.getSection(button.id);
                        continue;
                    }
                    List<ItemData> bag = this.bm.getBagItems(this.bm.bagSection);
                    this.bm.itemToUse = bag.get(button.id);
                    this.bm.lastItem = new ImmutablePair((Object)this.bm.bagSection, (Object)bag.get(button.id));
                    if (this.bm.bagSection == BagSection.POKEBALLS) {
                        this.bm.selectedActions.clear();
                        NetworkHelper.sendToServer(new BagPacket(this.bm.getCurrentPokemon().pokemonUUID, this.bm.itemToUse.getItemStack(), this.bm.battleControllerIndex, 0));
                        this.bm.setMode(BattleMode.WAITING);
                        continue;
                    }
                    this.bm.setMode(BattleMode.APPLY_TO_POKEMON);
                }
            }
        }
    }
}

