/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.screens.OverlayScreenState;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.CameraOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.client.listener.SendoutListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.quests.client.ui.GuiKeybindIconQuest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class PixelmonOverlayScreen
extends AbstractGui {
    public static final int SIDE_BAR_HEIGHT = 200;
    protected static final KeybindIcon POKEDEX_ICON = new KeybindIcon(ClientProxy.pokedexKeyBind, Resources.pokedexItemIcon);
    protected static final KeybindIcon WIKI_ICON = new KeybindIcon(ClientProxy.wikiKeyBind, Resources.wikiItemIcon);
    protected static final KeybindIcon TRAINER_CARD_ICON = new KeybindIcon(ClientProxy.trainerCardKeyBind, Resources.trainerCardItemIcon);
    protected static final KeybindIcon QUEST_ICON = new GuiKeybindIconQuest((KeyBinding)ClientProxy.questJournalKeyBind, ClientProxy.questCycleKeyBind);
    public static final List<KeybindIcon> ICONS = Lists.newArrayList((Object[])new KeybindIcon[]{POKEDEX_ICON, WIKI_ICON, TRAINER_CARD_ICON, QUEST_ICON});
    public static OverlayScreenState guiState = OverlayScreenState.ALL;
    public static String selectedMoveSkill;
    public static int targetId;
    public static boolean isVisible;
    private static String messageName;
    private static String oldMessageName;
    private static UUID uuid;
    private static UUID lastUuid;
    private static int fadeInTicks;
    private static int fadeOutTicks;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        MatrixStack matrix = event.getMatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (mc.field_71462_r != null && !(mc.field_71462_r instanceof ChatScreen) && !isVisible) {
            return;
        }
        if (mc.field_71462_r instanceof InventoryScreen || mc.field_71474_y.field_74319_N || mc.field_71462_r instanceof ItemDropsScreen) {
            return;
        }
        if (ClientStorageManager.party == null) {
            return;
        }
        matrix.func_227860_a_();
        CameraOverlayScreen.checkCameraOn();
        MainWindow var5 = mc.func_228018_at_();
        int screenWidth = var5.func_198107_o();
        int screenHeight = var5.func_198087_p();
        if (CameraOverlayScreen.isCameraGuiOn) {
            CameraOverlayScreen.renderCamera(matrix, screenWidth, screenHeight, mc);
        } else {
            PixelmonOverlayScreen.checkSelection();
            PlayerPartyStorage party = ClientStorageManager.party;
            if (party != null && party.getAll() != null && party.getAll().length != 0 && party.getSelectedPokemon() != null) {
                guiState.renderParty(matrix, Minecraft.func_71410_x(), party.getSelectedSlot(), party.getAll());
            }
            MainWindow eventResolution = event.getWindow();
            int scaledWidth = eventResolution.func_198107_o();
            Pokemon pokemon = party.getSelectedPokemon();
            if (pokemon != null) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                int potionsOffset = player.func_70651_bq().size() * 12;
                boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
                if (PixelmonConfigProxy.getGraphics().isShowCurrentAttackTarget() && isSentOut) {
                    ScreenHelper.drawImageQuad(Resources.targetArea, matrix, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawString(matrix, StringUtils.capitalize((String)ClientProxy.actionKeyBind.getKey().func_237520_d_().getString()), scaledWidth - 50 - potionsOffset, 0.0f, 0xFFFFFF, false, true);
                    if (targetId != -1) {
                        LivingEntity entity = (LivingEntity)mc.field_71441_e.func_73045_a(targetId);
                        if (entity instanceof PixelmonEntity) {
                            Pokemon target = ((PixelmonEntity)entity).getPokemon();
                            ScreenHelper.drawImageQuad(target.getSprite(), matrix, scaledWidth - 75 - potionsOffset, 3.0f, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        } else if (entity instanceof PlayerEntity) {
                            ScreenHelper.drawImageQuad(((AbstractClientPlayerEntity)entity).func_110306_p(), matrix, scaledWidth - 73 - potionsOffset, 5.0f, 18.0f, 18.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        } else if (entity instanceof NPCTrainer) {
                            ScreenHelper.drawImageQuad(AbstractClientPlayerEntity.func_110311_f((String)""), matrix, scaledWidth - 73 - potionsOffset, 5.0f, 18.0f, 18.0f, 0.125f, 0.125f, 0.25f, 0.25f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        }
                    } else {
                        ScreenHelper.drawImageQuad(Resources.notarget, matrix, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    }
                    ScreenHelper.drawImageQuad(Resources.targetAreaOver, matrix, scaledWidth - 76 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                } else {
                    targetId = -1;
                }
                if (isSentOut && PixelmonServerConfig.allowExternalMoves) {
                    MoveSkill selected;
                    ArrayList<MoveSkill> moveSkills = ClientProxy.getMoveSkills(ClientStorageManager.party.getSelectedPokemon());
                    MoveSkill moveSkill = selected = selectedMoveSkill == null ? null : CollectionHelper.find(moveSkills, ms -> ms.id.equals(selectedMoveSkill));
                    if (selected == null && !moveSkills.isEmpty()) {
                        selected = moveSkills.get(0);
                        selectedMoveSkill = selected.id;
                    }
                    if (selected != null) {
                        ScreenHelper.drawImageQuad(selected.sprite, matrix, scaledWidth - 42 - potionsOffset, 2.0f, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                        double cooldownRatio = pokemon.getMoveSkillCooldownRatio(selected);
                        if (cooldownRatio != 1.0) {
                            int pixels = (int)((1.0 - cooldownRatio) * 24.0);
                            mc.func_110434_K().func_110577_a(Resources.cooldown);
                            ScreenHelper.simpleDrawImageQuad(matrix, scaledWidth - 43 - potionsOffset, 25 - pixels, 26.0f, pixels + 2, 0.0f, 1.0f - (float)pixels / 24.0f, 1.0f, 1.0f, 0.0f);
                        }
                        ScreenHelper.drawString(matrix, StringUtils.capitalize((String)ClientProxy.useMoveSkillKeyBind.getKey().func_237520_d_().getString()), scaledWidth - 17 - player.func_70651_bq().size() * 12, 0.0f, 0xFFFFFF, false, true);
                        ScreenHelper.drawString(matrix, StringUtils.capitalize((String)ClientProxy.chooseMoveSkillKey.getKey().func_237520_d_().getString()), scaledWidth - 17 - player.func_70651_bq().size() * 12, 18.0f, 0xFFFFFF, false, true);
                        String nameString = I18n.func_135052_a((String)selected.name, (Object[])new Object[0]);
                        ScreenHelper.drawString(matrix, nameString, (float)(scaledWidth - 30 - potionsOffset) - (float)ScreenHelper.getStringWidth(nameString, true) / 2.0f, 26.0f, 0xFFFFFF, false, true);
                    }
                }
            }
            int scaledHeight = eventResolution.func_198087_p();
            int count = 0;
            for (KeybindIcon icon : ICONS) {
                if (icon instanceof GuiKeybindIconQuest) {
                    icon.draw(matrix, scaledWidth - 30, scaledHeight - 60, event.getPartialTicks());
                    continue;
                }
                icon.draw(matrix, scaledWidth - 30 - count++ * 25, scaledHeight - 30, event.getPartialTicks());
            }
            this.renderSpectateMessage(matrix, screenWidth, screenHeight);
        }
        matrix.func_227865_b_();
    }

    public static void selectNextPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        int selectedSlot = ClientStorageManager.party.getSelectedSlot();
        if (++selectedSlot >= 6) {
            selectedSlot = 0;
        }
        while (ClientStorageManager.party.get(selectedSlot) == null || ClientStorageManager.party.get(selectedSlot).isEgg()) {
            if (++selectedSlot < 6) continue;
            selectedSlot = 0;
        }
        ClientStorageManager.party.setSelectedSlot(selectedSlot, false);
        ClientStorageManager.party.sendClientUpdatePacket();
    }

    public static void selectPreviousPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        int selectedSlot = ClientStorageManager.party.getSelectedSlot();
        if (--selectedSlot < 0) {
            selectedSlot = 5;
        }
        while (ClientStorageManager.party.get(selectedSlot) == null || ClientStorageManager.party.get(selectedSlot).isEgg()) {
            if (--selectedSlot >= 0) continue;
            selectedSlot = 5;
        }
        ClientStorageManager.party.setSelectedSlot(selectedSlot, false);
        ClientStorageManager.party.sendClientUpdatePacket();
    }

    public static void checkSelection() {
        Pokemon current = ClientStorageManager.party.getSelectedPokemon();
        if ((current == null || current.isEgg()) && !ClientProxy.battleManager.isBattling()) {
            PixelmonOverlayScreen.selectPreviousPixelmon();
        }
    }

    public static void showSpectateMessage(UUID playerUuid) {
        PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(playerUuid);
        if (player == null) {
            return;
        }
        messageName = player.func_145748_c_().getString();
        uuid = playerUuid;
        fadeInTicks = 20;
    }

    public static void hideSpectateMessage(UUID playerUuid) {
        if (uuid == null) {
            fadeOutTicks = 0;
            messageName = null;
            return;
        }
        PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(uuid);
        if (player == null) {
            fadeOutTicks = 0;
            uuid = null;
            messageName = null;
            return;
        }
        fadeOutTicks = 15;
        oldMessageName = player.func_145748_c_().getString();
        lastUuid = uuid;
        if (uuid.equals(playerUuid)) {
            messageName = null;
            uuid = null;
        }
    }

    private void renderSpectateMessage(MatrixStack matrix, int screenWidth, int screenHeight) {
        int c;
        float alpha;
        int width;
        String spectateString;
        if (messageName != null) {
            spectateString = I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[]{I18n.func_135052_a((String)ClientProxy.spectateKeyBind.func_197982_m(), (Object[])new Object[0]), messageName});
            width = ScreenHelper.getStringWidth(spectateString, true);
            alpha = 1.0f - (float)fadeInTicks / 20.0f * 0.7f;
            c = ScreenHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            ScreenHelper.drawString(matrix, spectateString, (float)screenWidth / 2.0f - (float)width / 2.0f, (float)screenHeight / 2.0f + 30.0f, c, false, true);
        }
        if (oldMessageName != null && fadeOutTicks > 0) {
            spectateString = I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[]{I18n.func_135052_a((String)ClientProxy.spectateKeyBind.func_197982_m(), (Object[])new Object[0]), oldMessageName});
            width = ScreenHelper.getStringWidth(spectateString, true);
            alpha = (float)fadeOutTicks / 15.0f * 0.7f;
            c = ScreenHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            ScreenHelper.drawString(matrix, spectateString, (float)screenWidth / 2.0f - (float)width / 2.0f, (float)screenHeight / 2.0f + 30.0f, c, false, true);
        }
    }

    public static void onPlayerTick() {
        if (fadeInTicks > 0) {
            --fadeInTicks;
        }
        if (fadeOutTicks > 0) {
            --fadeOutTicks;
        }
    }

    public static UUID getCurrentSpectatingUUID() {
        if (uuid != null) {
            return uuid;
        }
        if (lastUuid != null && fadeOutTicks > 0) {
            return lastUuid;
        }
        return null;
    }

    static {
        targetId = -1;
        isVisible = true;
        messageName = null;
        oldMessageName = null;
        fadeInTicks = 0;
        fadeOutTicks = 0;
    }
}

