/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.ZygardeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import com.pixelmonmod.pixelmon.listener.ZygardeCellsListener;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class ReassemblyUnitTileEntity
extends TileEntity
implements ITickableTileEntity {
    private int ticks = 0;
    private Mode mode = Mode.INACTIVE;
    private UUID uuid = null;
    private StoragePosition position = null;
    private int cubeSlot = -999;

    public ReassemblyUnitTileEntity() {
        super((TileEntityType)TileEntityRegistration.REASSEMBLY_UNIT.get());
    }

    public void activate(ServerPlayerEntity player, BlockState state, ItemStack hand) {
        if (ZygardeCellsListener.checkForCube((PlayerEntity)player)) {
            if (!Pixelmon.EVENT_BUS.post((Event)new ZygardeEvent.Activate(player, this))) {
                OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.ZygardeAssembly, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.reassembly_unit.nocube", new Object[0]);
        }
    }

    public void onSelection(ServerPlayerEntity player, Mode mode, StoragePosition position, int cubeSlot) {
        ItemStack stack = player.field_71071_by.func_70301_a(cubeSlot);
        if (!(stack.func_77973_b() instanceof ZygardeCubeItem)) {
            return;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)new ZygardeEvent.Select(player, this, mode, position, stack, cubeSlot))) {
            this.uuid = player.func_110124_au();
            this.setMode(mode);
            this.position = position;
            this.cubeSlot = cubeSlot;
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.INACTIVE) {
            this.ticks = 0;
        }
        this.func_70296_d();
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
    }

    public Mode getMode() {
        return this.mode;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mode != Mode.INACTIVE) {
            ++this.ticks;
            if (this.ticks > 30) {
                PlayerEntity ep = this.func_145831_w().func_217371_b(this.uuid);
                if (!(ep instanceof ServerPlayerEntity)) {
                    this.reset();
                    return;
                }
                ServerPlayerEntity player = (ServerPlayerEntity)ep;
                ItemStack cube = player.field_71071_by.func_70301_a(this.cubeSlot);
                if (!(cube.func_77973_b() instanceof ZygardeCubeItem)) {
                    this.reset();
                    return;
                }
                if (this.mode == Mode.SEPARATING && this.position != null) {
                    PlayerPartyStorage storage = StorageProxy.getParty(this.uuid);
                    Pokemon pokemon = storage.get(this.position);
                    if (storage.countPokemon() == 1) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.gui.zygarde_reassembly.last_pokemon", new Object[0]);
                        this.reset();
                        return;
                    }
                    if (pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE) && !(pokemon.getAbility() instanceof PowerConstruct)) {
                        ZygardeEvent.Seperate event;
                        int cells = pokemon.getForm().isForm("ten_percent") ? 10 : (pokemon.getForm().isForm("fifty_percent") ? 50 : -1);
                        int cores = 1;
                        if (cells != -1 && !Pixelmon.EVENT_BUS.post((Event)(event = new ZygardeEvent.Seperate(player, this, pokemon, this.position, cube, cells, cores)))) {
                            storage.retrieveAll("BlockInteract");
                            storage.set(this.position, null);
                            ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) + event.cells);
                            ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) + event.cores);
                        }
                    }
                } else if (this.mode == Mode.ASSEMBLING && this.position != null) {
                    int cores;
                    int count;
                    ZygardeEvent.Assemble.Merge.Start startEvent;
                    PlayerPartyStorage storage = StorageProxy.getParty(this.uuid);
                    Pokemon pokemon = storage.get(this.position);
                    if (pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE) && !(pokemon.getAbility() instanceof PowerConstruct) && !Pixelmon.EVENT_BUS.post((Event)(startEvent = new ZygardeEvent.Assemble.Merge.Start(player, this, pokemon, this.position, cube, count = ZygardeCubeItem.getCellCount(cube), cores = ZygardeCubeItem.getCoreCount(cube))))) {
                        count = startEvent.cells;
                        cores = startEvent.cores;
                        int cellsExpended = 0;
                        int coresExpended = 0;
                        if (pokemon.getForm().isForm("ten_percent")) {
                            if (count >= 90 && cores >= 1) {
                                pokemon.setForm("fifty_percent");
                                pokemon.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                                cellsExpended = 90;
                                coresExpended = 1;
                            } else if (count >= 40) {
                                pokemon.setForm("fifty_percent");
                                pokemon.setAbility(AbilityRegistry.AURA_BREAK);
                                cellsExpended = 40;
                            }
                        } else if (pokemon.getForm().isForm("fifty_percent") && count >= 50 && cores >= 1) {
                            pokemon.setForm("fifty_percent");
                            pokemon.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                            cellsExpended = 50;
                            coresExpended = 1;
                        }
                        ZygardeEvent.Assemble.Merge.End endEvent = new ZygardeEvent.Assemble.Merge.End(player, this, pokemon, this.position, cube, cellsExpended, coresExpended);
                        Pixelmon.EVENT_BUS.post((Event)endEvent);
                        ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) - endEvent.cells);
                        ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) - endEvent.cores);
                    }
                } else if (this.mode == Mode.ASSEMBLING) {
                    ZygardeEvent.Assemble.New.Start startEvent;
                    boolean shiny;
                    int count = ZygardeCubeItem.getCellCount(cube);
                    int cores = ZygardeCubeItem.getCoreCount(cube);
                    Pokemon zygarde = PokemonFactory.create(PixelmonSpecies.ZYGARDE.getValueUnsafe());
                    zygarde.initialize(new InitializeCategory[0]);
                    boolean bl = shiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()));
                    if (shiny) {
                        zygarde.setShiny();
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(startEvent = new ZygardeEvent.Assemble.New.Start(player, this, zygarde, this.position, cube, count, cores)))) {
                        int cellsToRemove;
                        count = startEvent.cells;
                        cores = startEvent.cores;
                        if (count >= 100 && cores >= 2) {
                            zygarde.setForm("fifty_percent");
                            zygarde.setAbility(AbilityRegistry.POWER_CONSTRUCT);
                            cellsToRemove = 100;
                        } else if (count >= 50 && cores >= 1) {
                            zygarde.setForm("fifty_percent");
                            zygarde.setAbility(AbilityRegistry.AURA_BREAK);
                            cellsToRemove = 50;
                        } else if (count >= 10 && cores >= 1) {
                            zygarde.setForm("ten_percent");
                            zygarde.setAbility(AbilityRegistry.AURA_BREAK);
                            cellsToRemove = 10;
                        } else {
                            this.reset();
                            return;
                        }
                        zygarde.setLevel(30);
                        StorageProxy.getParty(this.uuid).add(zygarde);
                        ZygardeEvent.Assemble.New.End endEvent = new ZygardeEvent.Assemble.New.End(player, this, zygarde, this.position, cube, cellsToRemove, zygarde.getAbility() instanceof PowerConstruct ? 2 : 1);
                        Pixelmon.EVENT_BUS.post((Event)endEvent);
                        ZygardeCubeItem.setCellCount(cube, ZygardeCubeItem.getCellCount(cube) - endEvent.cells);
                        ZygardeCubeItem.setCoreCount(cube, ZygardeCubeItem.getCoreCount(cube) - endEvent.cores);
                    }
                }
                this.reset();
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        compound.func_74774_a("Mode", (byte)this.mode.ordinal());
        return compound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
        this.mode = Mode.fromOrdinal(compound.func_74771_c("Mode"));
    }

    private void reset() {
        this.mode = Mode.INACTIVE;
        this.ticks = 0;
        this.uuid = null;
        this.position = null;
        this.cubeSlot = -999;
        this.func_70296_d();
        this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
    }

    public static enum Mode {
        INACTIVE,
        ASSEMBLING,
        SEPARATING;

        private static final Mode[] VALUES;

        public static Mode fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

