/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerWorld;

public class PokeChestTileEntity
extends TileEntity {
    private EnumPokechestVisibility visibility = EnumPokechestVisibility.Visible;
    private EnumPokeChestType type = null;
    private UUID ownerID = null;
    private boolean chestOneTime = true;
    private boolean dropOneTime = true;
    private boolean doCustomDrop = false;
    private boolean timeEnabled = false;
    private ItemStack[] customDrops = null;
    private int frontFace = 4;
    private boolean grotto = false;
    private boolean isEvent = false;
    private List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeChestTileEntity() {
        super((TileEntityType)TileEntityRegistration.POKE_CHEST.get());
    }

    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    public UUID getOwner() {
        return this.ownerID;
    }

    public void setChestType(EnumPokeChestType type) {
        this.type = type;
    }

    public EnumPokeChestType getChestType() {
        if (this.type == null) {
            Block blockType = this.func_195044_w().func_177230_c();
            this.type = this.isEvent ? EnumPokeChestType.SPECIAL : (blockType == PixelmonBlocks.poke_chest ? EnumPokeChestType.POKEBALL : (blockType == PixelmonBlocks.ultra_chest ? EnumPokeChestType.ULTRABALL : (blockType == PixelmonBlocks.beast_chest ? EnumPokeChestType.BEASTBALL : (blockType == PixelmonBlocks.master_chest ? EnumPokeChestType.MASTERBALL : EnumPokeChestType.POKEBALL))));
        }
        return this.type;
    }

    public void setGrotto() {
        this.grotto = true;
    }

    public boolean isGrotto() {
        return this.grotto;
    }

    public CompoundNBT func_189515_b(CompoundNBT tagger) {
        ListNBT list;
        super.func_189515_b(tagger);
        tagger.func_186854_a("Owner", this.ownerID == null ? Util.field_240973_b_ : this.ownerID);
        tagger.func_74757_a("chestOneTime", this.chestOneTime);
        tagger.func_74757_a("dropOneTime", this.dropOneTime);
        tagger.func_74757_a("customDrop", this.doCustomDrop);
        tagger.func_74757_a("timeEnabled", this.timeEnabled);
        tagger.func_74757_a("grotto", this.grotto);
        tagger.func_74777_a("visibility", (short)this.visibility.ordinal());
        tagger.func_74757_a("specialEvent", this.isEvent);
        if (!this.claimed.isEmpty()) {
            list = new ListNBT();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundNBT playerInfoTag = new CompoundNBT();
                LootClaim playerClaim = this.claimed.get(i);
                playerInfoTag.func_186854_a("Claimer", playerClaim.getPlayerID());
                playerInfoTag.func_74772_a("timeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            tagger.func_218657_a("claimedPlayers", (INBT)list);
        }
        if (this.customDrops != null) {
            list = new ListNBT();
            for (ItemStack customDrop : this.customDrops) {
                CompoundNBT stackCompound = new CompoundNBT();
                if (customDrop == null) continue;
                list.add((Object)customDrop.func_77955_b(stackCompound));
            }
            tagger.func_218657_a("customDrops", (INBT)list);
        }
        return tagger;
    }

    public void writeToNBTClient(CompoundNBT tagger) {
        tagger.func_74757_a("specialEvent", this.isEvent);
        tagger.func_74777_a("visibility", (short)this.visibility.ordinal());
        super.func_189515_b(tagger);
    }

    public void readFromNBTClient(CompoundNBT tagger) {
        this.isEvent = tagger.func_74767_n("specialEvent");
        this.visibility = EnumPokechestVisibility.values()[tagger.func_74765_d("visibility")];
        super.func_230337_a_(this.func_195044_w(), tagger);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagger) {
        UUID uuid = tagger.func_186855_b("Owner") ? tagger.func_186857_a("Owner") : Util.field_240973_b_;
        this.ownerID = Objects.equals(Util.field_240973_b_, uuid) ? null : uuid;
        this.chestOneTime = tagger.func_74767_n("chestOneTime");
        this.dropOneTime = tagger.func_74767_n("dropOneTime");
        this.timeEnabled = tagger.func_74767_n("timeEnabled");
        this.grotto = tagger.func_74767_n("grotto");
        this.isEvent = tagger.func_74767_n("specialEvent");
        this.visibility = EnumPokechestVisibility.values()[tagger.func_74765_d("visibility")];
        this.doCustomDrop = tagger.func_74767_n("customDrop");
        if (this.isEvent) {
            this.timeEnabled = false;
            this.dropOneTime = true;
            this.chestOneTime = false;
        }
        if (tagger.func_74764_b("claimedPlayers")) {
            ListNBT claimedTag = tagger.func_150295_c("claimedPlayers", 10);
            for (INBT inbt : claimedTag) {
                CompoundNBT nbt = (CompoundNBT)inbt;
                this.claimed.add(new LootClaim(nbt.func_186857_a("Claimer"), nbt.func_74763_f("timeClaimed")));
            }
        }
        ListNBT dropList = tagger.func_150295_c("customDrops", 10);
        this.customDrops = new ItemStack[dropList.size()];
        for (int i = 0; i < this.customDrops.length; ++i) {
            this.customDrops[i] = ItemStack.func_199557_a((CompoundNBT)dropList.func_150305_b(i));
        }
        super.func_230337_a_(state, tagger);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.writeToNBTClient(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readFromNBTClient(pkt.func_148857_g());
    }

    public boolean canClaim(UUID playerID) {
        if (!this.dropOneTime) {
            return true;
        }
        LootClaim claim = this.getLootClaim(playerID);
        if (claim != null) {
            return this.timeEnabled && (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > (long)(PixelmonConfigProxy.getSpawning().getPokeLoot().getLootTime() * 3600);
        }
        return true;
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().equals(playerID)) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        if (this.dropOneTime || this.timeEnabled) {
            this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
        }
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public boolean shouldBreakBlock() {
        return this.chestOneTime && !this.timeEnabled;
    }

    public void setChestOneTime(boolean val) {
        this.chestOneTime = val;
    }

    public boolean getChestMode() {
        return this.chestOneTime;
    }

    public void setDropOneTime(boolean val) {
        this.dropOneTime = val;
    }

    public boolean getDropMode() {
        return this.dropOneTime;
    }

    public boolean isCustomDrop() {
        return this.doCustomDrop && this.customDrops != null;
    }

    public boolean isTimeEnabled() {
        return this.timeEnabled;
    }

    public void setTimeEnabled(boolean val) {
        this.timeEnabled = val;
    }

    public ItemStack[] getCustomDrops() {
        if (this.isEvent) {
            for (ItemStack s : this.customDrops) {
                if (s.func_77985_e()) continue;
                if (!s.func_77942_o()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74757_a("specialEvent", true);
                    s.func_77982_d(nbt);
                    continue;
                }
                s.func_77978_p().func_74757_a("specialEvent", true);
            }
        }
        return this.customDrops;
    }

    public void setCustomDrops(ItemStack ... customDrops) {
        this.doCustomDrop = true;
        this.customDrops = new ItemStack[customDrops.length];
        int index = 0;
        for (ItemStack stack : customDrops) {
            this.customDrops[index] = stack.func_77946_l();
            ++index;
        }
    }

    public void setCustomDropEnabled(boolean enabled) {
        this.doCustomDrop = enabled;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public void setFrontFace(int face) {
        this.frontFace = face;
    }

    public int getFrontFace() {
        return this.frontFace;
    }

    public void setSpecialEventDrop(ItemStack itemStack) {
        this.isEvent = true;
        this.chestOneTime = false;
        this.dropOneTime = true;
        this.setCustomDrops(itemStack);
    }

    public EnumPokechestVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EnumPokechestVisibility visible) {
        this.visibility = visible;
        ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.field_174879_c);
    }
}

