/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.IlexShrineEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.EncounterData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.machines.IlexShrineBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class IlexShrineTileEntity
extends TileEntity {
    public EncounterData encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());

    public IlexShrineTileEntity() {
        super((TileEntityType)TileEntityRegistration.ILEX_SHRINE.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("EncounterData", (INBT)this.encounters.write(new CompoundNBT()));
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
        if (nbt.func_74764_b("EncounterData")) {
            this.encounters.read(nbt.func_74775_l("EncounterData"));
        }
        if (this.getTileData().func_74764_b("encounters")) {
            ListNBT data = this.getTileData().func_150295_c("encounters", 8);
            for (INBT base : data) {
                StringNBT str = (StringNBT)base;
                UUID uuid = UUID.fromString(str.func_150285_a_());
                this.encounters.addEncounter(uuid, 1L);
            }
            this.getTileData().func_82580_o("encounters");
        }
    }

    public void activate(PlayerEntity player, IlexShrineBlock block, BlockState state, ItemStack item) {
        if (item != null && item.func_77973_b() == PixelmonItems.poke_ball && !player.field_70170_p.field_72995_K) {
            PokeBallPart.getPokeBall(item).ifPresent(ball -> {
                if (ball.is(PokeBallRegistry.GS_BALL)) {
                    Species species = PixelmonSpecies.CELEBI.getValueUnsafe();
                    PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
                    if (BattleRegistry.getBattle(player) == null) {
                        boolean shiny;
                        String spec = species.getName();
                        PixelmonEntity pixelmonEntity = PokemonSpecificationProxy.create(spec).create(player.field_70170_p);
                        boolean bl = shiny = PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((RegistryKey<World>)this.field_145850_b.func_234923_W_()));
                        if (shiny) {
                            pixelmonEntity.getPokemon().setPalette("shiny");
                        }
                        pixelmonEntity.func_70107_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p());
                        IlexShrineEvent.Pre pre = new IlexShrineEvent.Pre((ServerPlayerEntity)player, block, pixelmonEntity, this);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        if (this.encounters.canEncounter(player)) {
                            PixelmonEntity startingPixelmon;
                            if (Pixelmon.EVENT_BUS.post((Event)new IlexShrineEvent((ServerPlayerEntity)player, block, pre.getEntity(), this))) {
                                return;
                            }
                            if (this.encounters.getMode() == EnumEncounterMode.Once) {
                                player.field_70170_p.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)IlexShrineBlock.USED, (Comparable)Boolean.valueOf(true)), 2);
                                player.field_70170_p.func_180501_a(this.field_174879_c.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)IlexShrineBlock.USED, (Comparable)Boolean.valueOf(true))).func_206870_a(IlexShrineBlock.BLOCKPOS, (Comparable)((Object)EnumBlockPos.TOP)), 2);
                            }
                            if ((startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)player)) == null) {
                                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.partyfainted", new Object[0]);
                                return;
                            }
                            this.encounters.registerEncounter(player);
                            player.field_70170_p.func_217376_c((Entity)pre.getEntity());
                            item.func_190918_g(1);
                            PlayerParticipant playerParticipant = new PlayerParticipant((ServerPlayerEntity)player, startingPixelmon);
                            WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getEntity());
                            wildPixelmonParticipant.startedBattle = true;
                            BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                            Pixelmon.EVENT_BUS.post((Event)new IlexShrineEvent.Post((ServerPlayerEntity)player, block, pre.getEntity(), this));
                        } else if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.partyfainted", new Object[0]);
                    }
                }
            });
        }
    }
}

