/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.decorative;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.PokeDisplayOpenPacket;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PokeDisplayBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty UPSIDE_DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty RETURN = BooleanProperty.func_177716_a((String)"return");

    public PokeDisplayBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185853_f).func_200943_b(2.0f).func_235847_c_((p_test_1_, p_test_2_, p_test_3_) -> false).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)RETURN, (Comparable)Boolean.valueOf(true)));
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_180495_p(context.func_195995_a()).func_204520_s().func_206889_d()))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(context.func_196000_l().func_96559_d() == -1))).func_206870_a((Property)RETURN, (Comparable)Boolean.valueOf(true));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_);
        p_206840_1_.func_206894_a(new Property[]{WATERLOGGED, FACING, UPSIDE_DOWN, RETURN});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PokeDisplayTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult traceResult) {
        if (world.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.SUCCESS;
        }
        PokeDisplayTileEntity blockEntity = (PokeDisplayTileEntity)world.func_175625_s(pos);
        if (blockEntity.isLocked()) {
            return ActionResultType.PASS;
        }
        PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
        if (party == null || party.countAblePokemon() < 2 && !blockEntity.getStoredPoke().isPresent()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("poke.display.block.party.size"), Util.field_240973_b_);
            return ActionResultType.PASS;
        }
        blockEntity.setLocked(player);
        NetworkHelper.sendPacket((ServerPlayerEntity)player, new PokeDisplayOpenPacket(pos));
        return ActionResultType.SUCCESS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (world.field_72995_K) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof PokeDisplayTileEntity) {
            if (!((Boolean)state.func_177229_b((Property)RETURN)).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            PlayerPartyStorage party = StorageProxy.getParty((ServerPlayerEntity)player);
            PokeDisplayTileEntity pokeDisplayTileEntity = (PokeDisplayTileEntity)blockEntity;
            if (pokeDisplayTileEntity.getStoredPoke().isPresent()) {
                Pokemon storedPoke = pokeDisplayTileEntity.getStoredPoke().get();
                if (pokeDisplayTileEntity.getOriginalForm() != null) {
                    storedPoke.setForm(pokeDisplayTileEntity.getOriginalForm());
                }
                if (pokeDisplayTileEntity.getOriginalPalette() != null) {
                    storedPoke.setPalette(pokeDisplayTileEntity.getOriginalPalette());
                }
                party.add(storedPoke);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

