/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class Terrain
extends GlobalStatusBase {
    protected transient int turnsToGo;
    public String langStart;
    public String langEnd;

    public Terrain(StatusType type, String langStart, String langEnd, boolean extended) {
        super(type);
        this.turnsToGo = extended ? 8 : 5;
        this.langStart = langStart;
        this.langEnd = langEnd;
    }

    protected Terrain(StatusType type, int turnsToGo, String langStart, String langEnd) {
        super(type);
        this.turnsToGo = turnsToGo;
        this.langStart = langStart;
        this.langEnd = langEnd;
    }

    public void setTurns(int turns) {
        this.turnsToGo = turns;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Terrain terrain = user.bc.globalStatusController.getTerrain();
        if (terrain != null && terrain.type == this.type) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            if (terrain != null) {
                user.bc.globalStatusController.removeGlobalStatus(terrain);
            }
            user.bc.sendToAll(this.langStart, new Object[0]);
            Terrain newTerrain = this.getNewInstance();
            if (user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.terrainExtender) {
                newTerrain.turnsToGo = 8;
            }
            user.addGlobalStatus(newTerrain);
        }
    }

    public abstract Terrain getNewInstance();

    @Nonnull
    public abstract com.pixelmonmod.pixelmon.api.battles.Terrain getTerrainType();

    public abstract Element getTypingForTerrain();

    @Override
    public void applyRepeatedEffect(GlobalStatusController global) {
        if (--this.turnsToGo <= 0) {
            global.removeGlobalStatus(this);
            global.bc.sendToAll(this.langEnd, new Object[0]);
            return;
        }
        this.applyRepeatedEffect(global.bc);
    }

    public int getRemainingTurns() {
        return this.turnsToGo;
    }

    protected void applyRepeatedEffect(BattleController bc) {
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        int allyBenefits = 0;
        int opponentBenefits = 0;
        Terrain currentTerrain = pw.bc.globalStatusController.getTerrain();
        for (PixelmonWrapper ally : pw.getTeamPokemon()) {
            allyBenefits += this.countBenefits(pw, ally);
            allyBenefits -= currentTerrain.countBenefits(pw, ally);
        }
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            opponentBenefits += this.countBenefits(pw, opponent);
            opponentBenefits -= currentTerrain.countBenefits(pw, opponent);
        }
        if (allyBenefits > opponentBenefits) {
            userChoice.raiseWeight(40 * (allyBenefits - opponentBenefits));
        }
    }

    protected boolean affectsPokemon(PixelmonWrapper pw) {
        return !pw.isAirborne() && !pw.hasStatus(StatusType.Flying, StatusType.UnderGround, StatusType.Submerged, StatusType.Vanish);
    }

    protected abstract int countBenefits(PixelmonWrapper var1, PixelmonWrapper var2);

    public String toString() {
        return this.getTerrainType().name() + "[" + this.turnsToGo + " turns remaining]";
    }
}

