/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class NoRetreat
extends StatusBase {
    transient PixelmonWrapper locker;

    public NoRetreat() {
        super(StatusType.NoRetreat);
    }

    public NoRetreat(PixelmonWrapper locker) {
        super(StatusType.NoRetreat);
        this.locker = locker;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasStatus(StatusType.NoRetreat)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        for (BattleStatsType type : BattleStatsType.getUniqueBattleStatValues()) {
            user.getBattleStats().modifyStat(1, type, user, true);
        }
        if (!user.hasStatus(StatusType.MeanLook) && user.addStatus(new NoRetreat(user), user)) {
            user.bc.sendToAll("pixelmon.effect.noescape", user.getNickname());
        }
    }

    @Override
    public boolean stopsSwitching() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (!pw.bc.isInBattle(this.locker)) {
            pw.removeStatus(this);
        }
    }
}

