/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Infiltrator;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Steadfast;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Flinch
extends StatusBase {
    public static boolean targetHadSubstitute;

    public Flinch() {
        super(StatusType.Flinch);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isDynamax()) {
            return;
        }
        if (this.checkChance()) {
            Flinch.flinch(user, target);
        }
    }

    public static void flinch(PixelmonWrapper user, PixelmonWrapper target) {
        if (!(target.hasStatus(StatusType.Flinch) || target.bc == null || target.takenTurn || target.attack == null || target.hasStatus(StatusType.Substitute) && !(user.getBattleAbility() instanceof Infiltrator) || targetHadSubstitute)) {
            target.addStatus(new Flinch(), user);
        }
    }

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        targetHadSubstitute = target.hasStatus(StatusType.Substitute);
        return AttackResult.proceed;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        user.bc.sendToAll("battlecontroller.flinched", user.getNickname());
        Ability ability = user.getBattleAbility();
        if (ability instanceof Steadfast) {
            ability.sendActivatedMessage(user);
            user.getBattleStats().modifyStat(1, BattleStatsType.SPEED);
        }
        return false;
    }

    @Override
    public void onEndOfTurn(PixelmonWrapper user) {
        user.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        float chance = this.getChance();
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (MoveChoice.canOutspeed(bestOpponentChoices, pw, userChoice.createList()) || !target.addStatus(new Flinch(), pw)) continue;
            if (chance == 100.0f) {
                userChoice.raiseWeight(chance);
                continue;
            }
            if (chance >= 50.0f) {
                userChoice.raiseWeight(chance / 2.0f);
                continue;
            }
            userChoice.raiseWeight(chance / 100.0f);
        }
    }
}

