/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class DestinyBond
extends StatusBase {
    public DestinyBond() {
        super(StatusType.DestinyBond);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.lastAttack != null && user.lastAttack.getMove() != null && user.lastAttack.getMove().isAttack(AttackRegistry.DESTINY_BOND) && user.lastAttack.moveResult != null && user.lastAttack.moveResult.result != null && user.lastAttack.moveResult.result.isSuccess()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        if (user.addStatus(new DestinyBond(), user)) {
            user.bc.sendToAll("pixelmon.effect.applydestinybond", user.getNickname());
            user.attack.moveResult.result = AttackResult.succeeded;
        } else {
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        user.removeStatus(this);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (pokemon.isFainted() && (damagetype == DamageTypeEnum.ATTACK || damagetype == DamageTypeEnum.ATTACKFIXED) && !user.isAlly(pokemon)) {
            if (user.isDynamax > 0) {
                user.bc.sendToAll("pixelmon.effect.blockedbydynamax", new Object[0]);
                return;
            }
            user.bc.sendToAll("pixelmon.effect.destinybond", pokemon.getNickname());
            user.doBattleDamage(pokemon, user.getHealth(), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, userChoice.createList())) {
            userChoice.raiseWeight(75.0f);
        }
    }
}

