/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class Charge
extends StatusBase {
    public Charge() {
        super(StatusType.Charge);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.charge", user.getNickname());
        if (!user.hasStatus(StatusType.Charge)) {
            user.addStatus(new Charge(), user);
        }
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.getType() == Element.ELECTRIC) {
            power *= 2;
            user.removeStatus(this);
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (!pw.hasStatus(StatusType.Charge) && MoveChoice.hasOffensiveAttackType(bestUserChoices, Element.ELECTRIC)) {
            userChoice.raiseWeight(50.0f);
        }
    }
}

