/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log.action.type;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.log.action.BattleAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;
import java.util.stream.Collectors;

public class SelectAttackAction
extends BattleAction {
    private final String participantName;
    private final String pokemonName;
    protected final String attackName;
    protected final List<PixelmonWrapper> targets;
    protected final boolean megaEvolve;

    public SelectAttackAction(int turn, PixelmonWrapper pokemon, Attack attack, List<PixelmonWrapper> targets, boolean megaEvolve) {
        super(turn);
        this.participantName = pokemon.getParticipant().getDisplayName();
        this.pokemonName = pokemon.getPokemonName();
        this.attackName = attack.getMove().getAttackName();
        this.targets = Lists.newArrayList(targets);
        this.megaEvolve = megaEvolve;
    }

    @Override
    public boolean appendLog(StringBuilder builder) {
        builder.append(this.participantName).append(" selected attack ").append(this.attackName).append(" for ").append(this.pokemonName).append(" targeting ").append(this.targets.stream().map(PixelmonWrapper::getPokemonName).collect(Collectors.joining(", ")));
        if (this.megaEvolve) {
            builder.append(" and opted to mega evolve");
        }
        return true;
    }
}

