/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.ai;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.BattleAIBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AggressiveAI
extends BattleAIBase {
    public AggressiveAI(BattleParticipant participant) {
        super(participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoveChoice getNextMove(PixelmonWrapper pw) {
        List<MoveChoice> choices = this.getAttackChoicesOpponentOnly(pw);
        ArrayList<PixelmonWrapper> allies = pw.getTeamPokemonExcludeSelf();
        ArrayList<MoveChoice> bestChoices = new ArrayList<MoveChoice>();
        boolean wasSimulateMode = this.bc.simulateMode;
        this.bc.simulateMode = true;
        try {
            this.bc.modifyStats();
            this.bc.modifyStatsCancellable(pw);
            for (MoveChoice choice : choices) {
                if (choice.attack.getAttackCategory() == AttackCategory.STATUS) continue;
                this.weightOffensiveMove(pw, choice, allies);
                if (choice.attack.isAttack(AttackRegistry.EXPLOSION, AttackRegistry.FINAL_GAMBIT, AttackRegistry.SELF_DESTRUCT)) {
                    choice.weight = 0.0f;
                }
                MoveChoice.checkBestChoice(choice, bestChoices);
            }
        }
        finally {
            this.bc.simulateMode = wasSimulateMode;
        }
        if (bestChoices.isEmpty()) {
            return RandomHelper.getRandomElementFromList(choices);
        }
        return (MoveChoice)RandomHelper.getRandomElementFromList(bestChoices);
    }

    protected MoveChoice getNextMoveAttackOnly(PixelmonWrapper pw) {
        return this.getNextMove(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getNextSwitch(PixelmonWrapper pw) {
        ArrayList<UUID> bestSwitches = new ArrayList<UUID>();
        int controlledIndex = pw.getControlledIndex();
        List<UUID> party = this.getPossibleSwitchIDs();
        if (party.isEmpty()) {
            return null;
        }
        if (party.size() == 1) {
            return party.get(0);
        }
        boolean allFainted = true;
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            allFainted = allFainted && opponent.isFainted();
        }
        if (allFainted || controlledIndex == -1) {
            return RandomHelper.getRandomElementFromList(party);
        }
        boolean wasSimulateMode = this.bc.simulateMode;
        this.bc.simulateMode = true;
        try {
            MoveChoice bestChoice = null;
            for (UUID partyUUID : party) {
                this.bc.simulateMode = true;
                pw.newPokemonUUID = partyUUID;
                PixelmonWrapper nextPokemon = pw.doSwitch();
                try {
                    if (!this.validateSwitch(nextPokemon)) continue;
                    MoveChoice choice = this.getNextMoveAttackOnly(nextPokemon);
                    if (choice.compareTo(bestChoice) > 0) {
                        bestSwitches.clear();
                    }
                    if (choice.compareTo(bestChoice) < 0) continue;
                    bestChoice = choice;
                    bestSwitches.add(partyUUID);
                }
                finally {
                    this.resetSwitchSimulation(pw, controlledIndex, nextPokemon);
                }
            }
        }
        finally {
            this.bc.simulateMode = wasSimulateMode;
        }
        UUID bestSwitch = RandomHelper.getRandomElementFromList(bestSwitches.isEmpty() ? party : bestSwitches);
        return bestSwitch;
    }

    @Override
    public UUID getFaintedPokemonToRevive() {
        return RandomHelper.getRandomElementFromList(this.getPossibleReviveIDs());
    }

    protected boolean validateSwitch(PixelmonWrapper nextPokemon) {
        return true;
    }

    protected void resetSwitchSimulation(PixelmonWrapper current, int controlledIndex, PixelmonWrapper simulated) {
        this.participant.controlledPokemon.set(controlledIndex, current);
    }
}

