/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.ai;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.TacticalAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.EntryHazard;
import com.pixelmonmod.pixelmon.battles.status.Perish;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AdvancedAI
extends TacticalAI {
    public AdvancedAI(BattleParticipant participant) {
        super(participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoveChoice getNextMove(PixelmonWrapper pw) {
        List<MoveChoice> choices = this.getWeightedAttackChoices(pw);
        List<MoveChoice> bestChoices = this.getBestChoices(choices);
        MoveChoice bestChoice = this.pickBestChoice(choices, bestChoices);
        List<MoveChoice> switchChoices = this.getSwitchChoices(pw);
        ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
        if (!switchChoices.isEmpty()) {
            int controlledIndex = pw.getControlledIndex();
            int statBoostMod = pw.getBattleStats().getSumStages() * -20;
            boolean willFaintPerishSong = false;
            Perish perishSong = (Perish)pw.getStatus(StatusType.Perish);
            if (perishSong != null) {
                willFaintPerishSong = perishSong.effectTurns == 1;
            }
            boolean wasSimulateMode = this.bc.simulateMode;
            this.bc.simulateMode = true;
            try {
                List<MoveChoice> bestOpponentChoicesBefore = this.getNextOpponentMoves(pw, opponents);
                float opponentChoicesBeforeSum = MoveChoice.sumWeights(bestOpponentChoicesBefore);
                for (MoveChoice switchChoice : switchChoices) {
                    pw.newPokemonUUID = switchChoice.switchPokemon;
                    PixelmonWrapper nextPokemon = pw.doSwitch();
                    int totalHazardDamage = 0;
                    int beforeHealth = nextPokemon.getHealth();
                    for (EntryHazard hazard2 : pw.getEntryHazards().stream().filter(hazard -> !hazard.isImmune(nextPokemon)).collect(Collectors.toList())) {
                        int damage = hazard2.getDamage(nextPokemon);
                        if (damage > 0) {
                            totalHazardDamage += damage;
                            switchChoice.raiseWeight(-damage);
                            continue;
                        }
                        float weight = -hazard2.getAIWeight() * hazard2.getNumLayers();
                        if (hazard2.type == StatusType.ToxicSpikes && pw.hasType(Element.POISON)) {
                            weight = -weight;
                        }
                        switchChoice.raiseWeight(weight);
                    }
                    if (totalHazardDamage >= beforeHealth) {
                        switchChoice.lowerTier(0);
                        nextPokemon.setHealth(beforeHealth);
                        this.resetSwitchSimulation(pw, controlledIndex, nextPokemon);
                        continue;
                    }
                    nextPokemon.setHealth(beforeHealth - totalHazardDamage);
                    try {
                        MoveChoice choice = this.getNextMoveAttackOnly(nextPokemon);
                        BattlePriorityHelper.checkMoveSpeed(pw.bc);
                        List<MoveChoice> bestOpponentChoicesAfter = this.getNextOpponentMoves(pw, opponents);
                        if (choice == null || !(choice.weight > 0.0f) || MoveChoice.canOutspeedAnd2HKO(bestOpponentChoicesAfter, nextPokemon)) continue;
                        float userChoiceWeight = choice.weight - bestChoice.weight;
                        float opponentChoiceWeight = opponentChoicesBeforeSum - MoveChoice.sumWeights(bestOpponentChoicesAfter);
                        for (PixelmonWrapper opponent : opponents) {
                            if (opponent.lastAttack == null || opponent.lastAttack.getAttackCategory() == AttackCategory.STATUS || opponent.lastAttack.moveResult.target != pw || opponent.lastAttack.getTypeEffectiveness(opponent, nextPokemon) != (double)Effectiveness.None.value) continue;
                            userChoiceWeight += 30.0f;
                        }
                        switchChoice.raiseWeight((userChoiceWeight += (float)statBoostMod) + opponentChoiceWeight);
                        if (!willFaintPerishSong) continue;
                        switchChoice.raiseTier(3);
                    }
                    finally {
                        nextPokemon.setHealth(beforeHealth);
                        this.resetSwitchSimulation(pw, controlledIndex, nextPokemon);
                    }
                }
            }
            finally {
                this.bc.simulateMode = wasSimulateMode;
            }
            choices.addAll(switchChoices);
        }
        bestChoices = this.getBestChoices(choices);
        bestChoice = this.pickBestChoice(choices, bestChoices);
        if (bestChoice.switchPokemon != null) {
            pw.getParticipant().switchingIn.add(bestChoice.switchPokemon);
        }
        return bestChoice;
    }

    @Override
    protected MoveChoice getNextMoveAttackOnly(PixelmonWrapper pw) {
        return super.getNextMove(pw);
    }

    protected List<MoveChoice> getNextOpponentMoves(PixelmonWrapper pw, List<PixelmonWrapper> opponents) {
        ArrayList<MoveChoice> bestOpponentChoices = new ArrayList<MoveChoice>();
        for (PixelmonWrapper opponent : pw.getOpponentPokemon()) {
            List<MoveChoice> singleOpponentChoices = pw.getBattleAI().getWeightedOffensiveChoices(opponent);
            MoveChoice bestChoice = this.pickBestChoice(this.getBestChoices(singleOpponentChoices));
            if (bestChoice == null) continue;
            bestOpponentChoices.add(bestChoice);
        }
        return bestOpponentChoices;
    }

    @Override
    protected boolean validateSwitch(PixelmonWrapper nextPokemon) {
        this.bc.modifyStats();
        this.bc.modifyStatsCancellable(nextPokemon);
        List<PixelmonWrapper> saveTurnList = this.bc.turnList;
        BattlePriorityHelper.checkMoveSpeed(nextPokemon.bc);
        List<MoveChoice> opponentChoices = this.getNextOpponentMoves(nextPokemon, nextPokemon.getOpponentPokemon());
        boolean canSurvive = !MoveChoice.canOutspeedAndOHKO(opponentChoices, nextPokemon, this.getBestChoices(this.getWeightedAttackChoices(nextPokemon)));
        this.bc.turnList = saveTurnList;
        return canSurvive;
    }
}

