/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Substitute;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;

public class ShedTail
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        float health = user.getPercentMaxHealth(50.0f);
        if (user.hasStatus(StatusType.Substitute) || (float)user.getHealth() <= health) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        BattleParticipant userParticipant = user.getParticipant();
        if (!userParticipant.hasMorePokemonReserve()) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        if (user.bc.simulateMode) {
            return AttackResult.succeeded;
        }
        if (user.addStatus(new Substitute((int)health / 2), user)) {
            user.doBattleDamage(user, health, DamageTypeEnum.SELF);
            user.bc.sendToAll("pixelmon.effect.createsubstitute", user.getNickname());
        }
        user.nextSwitchIsMove = true;
        if (userParticipant instanceof TrainerParticipant) {
            user.bc.switchPokemon(user.getPokemonUUID(), user.getBattleAI().getNextSwitch(user), true);
        } else if (userParticipant instanceof PlayerParticipant) {
            user.wait = true;
            NetworkHelper.sendPacket(new EnforcedSwitchTask(user.bc.getPositionOfPokemon(user, user.getParticipant()), user.nextSwitchIsMove), user.getPlayerOwner());
        } else {
            user.nextSwitchIsMove = false;
        }
        return AttackResult.succeeded;
    }
}

