/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CourtChange
extends SpecialAttackBase {
    private static final transient List<StatusType> transferableStatuses = Arrays.asList(StatusType.Reflect, StatusType.LightScreen, StatusType.AuroraVeil, StatusType.StealthRock, StatusType.Spikes, StatusType.StickyWeb, StatusType.ToxicSpikes, StatusType.Tailwind, StatusType.Steelsurge, StatusType.FirePledge, StatusType.GrassPledge, StatusType.WaterPledge, StatusType.Mist, StatusType.SafeGuard, StatusType.GMaxRepeatDamage);

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        PixelmonWrapper pw;
        Iterator<StatusBase> iterator;
        ArrayList<StatusBase> transfer;
        if (user != target) {
            return AttackResult.proceed;
        }
        BattleController bc = user.bc;
        ArrayList<PixelmonWrapper> opponents = user.getOpponentPokemon();
        HashMap toTransferToUser = new HashMap();
        HashMap toTransferToTarget = new HashMap();
        for (PixelmonWrapper pixelmonWrapper : user.getTeamPokemon()) {
            if (bc.getOppositePokemon(pixelmonWrapper) == null) continue;
            transfer = new ArrayList<StatusBase>();
            iterator = pixelmonWrapper.getStatuses().iterator();
            while (iterator.hasNext()) {
                StatusBase status2 = iterator.next();
                if (!transferableStatuses.contains(status2.type)) continue;
                transfer.add(status2);
                iterator.remove();
            }
            toTransferToTarget.put(bc.getOppositePokemon(pixelmonWrapper), transfer);
        }
        for (PixelmonWrapper pixelmonWrapper : opponents) {
            transfer = new ArrayList();
            iterator = pixelmonWrapper.getStatuses().iterator();
            while (iterator.hasNext()) {
                StatusBase status = iterator.next();
                if (!transferableStatuses.contains(status.type)) continue;
                transfer.add(status);
                iterator.remove();
            }
            toTransferToUser.put(bc.getOppositePokemon(pixelmonWrapper), transfer);
        }
        for (Map.Entry entry : toTransferToTarget.entrySet()) {
            pw = (PixelmonWrapper)entry.getKey();
            for (StatusBase status : (List)entry.getValue()) {
                pw.addStatus(status, bc.getOppositePokemon(pw));
            }
        }
        for (Map.Entry entry : toTransferToUser.entrySet()) {
            pw = (PixelmonWrapper)entry.getKey();
            for (StatusBase status : (List)entry.getValue()) {
                pw.addStatus(status, bc.getOppositePokemon(pw));
            }
        }
        return AttackResult.proceed;
    }

    @Override
    public void applyAfterEffect(PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.effect.courtchange", user.getNickname());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
    }
}

