/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Competitive;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Contrary;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Defiant;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Unaware;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationStationary;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackStatChange;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.OHKO;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StatsEffectCone
extends StatsEffect {
    public StatsEffectCone() {
    }

    public StatsEffectCone(BattleStatsType type, int value, boolean isUser) {
        super(type, value, isUser);
    }

    @Override
    public AttackResult applyStatEffect(PixelmonWrapper user, PixelmonWrapper target, ImmutableAttack a) {
        ArrayList<PixelmonWrapper> affectedList = user.bc.getAdjacentPokemonAndSelf(this.isUser ? user : target);
        for (PixelmonWrapper affected : affectedList) {
            boolean increase;
            if (affected.isFainted() || affected.isSameTeam(user) || !this.checkChance()) continue;
            if (affected.getBattleStats().modifyStat(this.amount, this.type, user, true)) {
                StatsEffectCone.addStatChangeAnimation(user, affected, this.type, this.amount);
                continue;
            }
            if (a != null && a.getAttackCategory() != AttackCategory.STATUS) {
                StatsEffectCone.addStatChangeAnimation(user, affected, this.type, this.amount);
                continue;
            }
            if (this.amount == 0) continue;
            boolean bl = increase = this.amount > 0;
            if (affected.getBattleAbility(user) instanceof Contrary && (!user.attack.isZ || user.attack.isAttack(AttackRegistry.EXTREME_EVOBOOST))) {
                increase = !increase;
            }
            affected.getBattleStats().getStatFailureMessage(this.type, increase);
        }
        return AttackResult.succeeded;
    }

    public static void addStatChangeAnimation(PixelmonWrapper user, PixelmonWrapper target, BattleStatsType stat, int stages) {
        if (user.bc.simulateMode) {
            return;
        }
        AttackAnimationStationary animation = new AttackAnimationStationary();
        animation.effects = new HashMap();
        animation.durationTicks = 20;
        AttackStatChange.StatChangeData effect = new AttackStatChange.StatChangeData(stat, stages);
        animation.effects.put(0, effect);
        animation.groundedEndPosition = true;
        animation.initialize(user, target, user.attack == null ? new Attack(AttackRegistry.TACKLE) : user.attack);
        user.bc.addAnimation(animation);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        this.applyStatEffect(user, target, null);
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) {
        return this.isUser;
    }

    @Override
    public BattleStatsType getStatsType() {
        return this.type;
    }

    @Override
    public boolean getUser() {
        return this.isUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> opponents;
        float chance = this.getChance();
        if (chance < 50.0f) {
            if (userChoice.isMiddleTier() || this.isUser) {
                userChoice.raiseWeight(chance / 100.0f);
            }
            return;
        }
        if (!this.isUser && this.amount < 0) {
            if (userChoice.hitsAlly()) {
                return;
            }
            for (PixelmonWrapper target : userChoice.targets) {
                if (!(target.getBattleAbility() instanceof Competitive) && !(target.getBattleAbility() instanceof Defiant)) continue;
                userChoice.weight -= 50.0f;
            }
        }
        if (this.type == BattleStatsType.ATTACK || this.type == BattleStatsType.SPECIAL_ATTACK || this.type == BattleStatsType.DEFENSE || this.type == BattleStatsType.SPECIAL_DEFENSE) {
            pw.bc.sendMessages = false;
            if (this.isUser && (this.type == BattleStatsType.ATTACK || this.type == BattleStatsType.SPECIAL_ATTACK) || !this.isUser && (this.type == BattleStatsType.DEFENSE || this.type == BattleStatsType.SPECIAL_DEFENSE)) {
                List<MoveChoice> bestChoicesAfter;
                List<MoveChoice> bestChoicesBefore = bestUserChoices;
                pw.bc.simulateMode = false;
                BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
                BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
                if (this.isUser) {
                    originalStats[0] = pw.getBattleStats();
                    saveStats[0] = new BattleStats(originalStats[0]);
                } else {
                    for (int i = 0; i < originalStats.length; ++i) {
                        originalStats[i] = userChoice.targets.get(i).getBattleStats();
                        saveStats[i] = new BattleStats(originalStats[i]);
                    }
                }
                try {
                    if (this.isUser) {
                        pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    } else {
                        for (PixelmonWrapper target : userChoice.targets) {
                            target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                        }
                    }
                    pw.bc.simulateMode = true;
                    bestChoicesAfter = pw.getBattleAI().getBestAttackChoices(pw);
                    pw.bc.simulateMode = false;
                }
                finally {
                    pw.bc.simulateMode = false;
                    for (int i = 0; i < originalStats.length; ++i) {
                        originalStats[i].copyStats(saveStats[i]);
                    }
                }
                boolean weightNegative = true;
                if (this.isUser) {
                    EnumHeldItems heldItem = pw.getUsableHeldItem().getHeldItemType();
                    weightNegative = heldItem != EnumHeldItems.whiteHerb && heldItem != EnumHeldItems.ginemaBerry;
                }
                pw.getBattleAI().weightFromUserOptions(pw, userChoice, bestChoicesBefore, bestChoicesAfter, weightNegative);
                if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices) && !userChoice.isOffensiveMove()) {
                    userChoice.lowerTier(1);
                }
            } else if (this.isUser && (this.type == BattleStatsType.DEFENSE || this.type == BattleStatsType.SPECIAL_DEFENSE) || !this.isUser && (this.type == BattleStatsType.ATTACK || this.type == BattleStatsType.SPECIAL_ATTACK)) {
                int i;
                opponents = this.getAffectedOpponents(pw, userChoice);
                List<List<MoveChoice>> bestChoicesBefore = MoveChoice.splitChoices(opponents, bestOpponentChoices);
                ArrayList<List<MoveChoice>> bestChoicesAfter = new ArrayList<List<MoveChoice>>(opponents.size());
                pw.bc.simulateMode = false;
                BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
                BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
                if (this.isUser) {
                    originalStats[0] = pw.getBattleStats();
                    saveStats[0] = new BattleStats(originalStats[0]);
                } else {
                    for (i = 0; i < originalStats.length; ++i) {
                        originalStats[i] = userChoice.targets.get(i).getBattleStats();
                        saveStats[i] = new BattleStats(originalStats[i]);
                    }
                }
                try {
                    if (this.isUser) {
                        pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    } else {
                        for (i = 0; i < saveStats.length; ++i) {
                            PixelmonWrapper target = userChoice.targets.get(i);
                            target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                        }
                    }
                    pw.bc.simulateMode = true;
                    for (PixelmonWrapper opponent : opponents) {
                        List<MoveChoice> after = pw.getBattleAI().getBestAttackChoices(opponent);
                        bestChoicesAfter.add(after);
                    }
                    pw.bc.simulateMode = false;
                }
                finally {
                    pw.bc.simulateMode = false;
                    for (int i2 = 0; i2 < saveStats.length; ++i2) {
                        originalStats[i2].copyStats(saveStats[i2]);
                    }
                }
                if (bestChoicesBefore.size() != bestChoicesAfter.size()) {
                    pw.bc.simulateMode = true;
                    pw.bc.sendMessages = true;
                    return;
                }
                pw.getBattleAI().weightFromOpponentOptions(pw, userChoice, bestChoicesBefore, bestChoicesAfter, false);
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
        } else if (this.type == BattleStatsType.SPEED) {
            if (!this.isUser) {
                bestOpponentChoices = MoveChoice.getAffectedChoices(userChoice, bestOpponentChoices);
            }
            if (MoveChoice.hasPriority(bestUserChoices, bestOpponentChoices)) {
                return;
            }
            opponents = this.getAffectedOpponents(pw, userChoice);
            int numOutspeedingOpponentsBefore = 0;
            int numOutspeedingOpponentsAfter = 0;
            for (PixelmonWrapper opponent : opponents) {
                if (pw.bc.getFirstMover(pw, opponent) != opponent) continue;
                ++numOutspeedingOpponentsBefore;
            }
            if (numOutspeedingOpponentsBefore == 0) {
                return;
            }
            pw.bc.sendMessages = false;
            pw.bc.simulateMode = false;
            BattleStats[] originalStats = new BattleStats[userChoice.targets.size()];
            BattleStats[] saveStats = new BattleStats[userChoice.targets.size()];
            if (this.isUser) {
                originalStats[0] = pw.getBattleStats();
                saveStats[0] = new BattleStats(originalStats[0]);
            } else {
                for (int i = 0; i < originalStats.length; ++i) {
                    originalStats[i] = userChoice.targets.get(i).getBattleStats();
                    saveStats[i] = new BattleStats(originalStats[i]);
                }
            }
            try {
                if (this.isUser) {
                    pw.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                } else {
                    for (PixelmonWrapper target : userChoice.targets) {
                        target.getBattleStats().modifyStat(this.amount, this.type, pw, true);
                    }
                }
                BattlePriorityHelper.checkMoveSpeed(pw.bc);
                for (PixelmonWrapper opponent : opponents) {
                    if (pw.bc.getFirstMover(pw, opponent) != opponent) continue;
                    ++numOutspeedingOpponentsAfter;
                }
            }
            finally {
                for (int i = 0; i < originalStats.length; ++i) {
                    originalStats[i].copyStats(saveStats[i]);
                }
            }
            pw.bc.simulateMode = true;
            pw.bc.sendMessages = true;
            if (numOutspeedingOpponentsAfter == 0) {
                userChoice.raiseWeight(75.0f);
            }
        } else if (this.type == BattleStatsType.ACCURACY || this.type == BattleStatsType.EVASION) {
            boolean affectsUser;
            boolean bl = affectsUser = this.isUser && this.type == BattleStatsType.ACCURACY || !this.isUser && this.type == BattleStatsType.EVASION;
            if (affectsUser) {
                for (MoveChoice bestUserChoice : bestUserChoices) {
                    if (!bestUserChoice.isOffensiveMove()) continue;
                    if (bestUserChoice.result.accuracy < 0 || bestUserChoice.result.accuracy == 100) {
                        return;
                    }
                    for (EffectBase effect : bestUserChoice.attack.getMove().effects) {
                        if (!(effect instanceof OHKO)) continue;
                        return;
                    }
                }
                if (MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices)) {
                    return;
                }
            } else {
                for (MoveChoice bestOpponentChoice : bestOpponentChoices) {
                    if (!bestOpponentChoice.isOffensiveMove()) continue;
                    if (bestOpponentChoice.result.accuracy < 0) {
                        return;
                    }
                    for (EffectBase effect : bestOpponentChoice.attack.getMove().effects) {
                        if (!(effect instanceof OHKO)) continue;
                        return;
                    }
                }
            }
            if (this.isUser && pw.getBattleAbility() instanceof Contrary) {
                return;
            }
            ArrayList<PixelmonWrapper> opponents2 = this.getAffectedOpponents(pw, userChoice);
            for (PixelmonWrapper opponent : opponents2) {
                Ability opponentAbility = opponent.getBattleAbility();
                if (!(opponentAbility instanceof Unaware) && (this.isUser || !(opponentAbility instanceof Contrary))) continue;
                return;
            }
            userChoice.raiseWeight(20 * Math.abs(this.amount));
        }
        if (this.isUser && this.amount > 0 && MoveChoice.hasSuccessfulAttackChoice(userChoices, AttackRegistry.BATON_PASS, AttackRegistry.STORED_POWER)) {
            userChoice.raiseWeight(10 * this.amount);
        }
        if (!this.isUser && userChoice.weight > 100.0f) {
            userChoice.weight = 100.0f;
        }
    }

    private ArrayList<PixelmonWrapper> getAffectedOpponents(PixelmonWrapper pw, MoveChoice choice) {
        return pw.bc.getAdjacentPokemonAndSelf(this.isUser ? pw : (choice.targets.size() > 0 ? choice.targets.get(0) : null));
    }
}

