/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystem;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackBeam
extends AttackSystem<BeamData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        float[] trueStart = this.getStartPos();
        float trueVariation = ((BeamData)this.getData()).getVariation();
        if (((BeamData)this.getData()).isInverted()) {
            trueStart = this.getEndPos();
            this.setEndPos(this.getStartPos());
            this.setStartPos(trueStart);
            PixelmonEntity target = (PixelmonEntity)w.func_73045_a(this.getEndID());
            trueVariation = target == null ? 1.0f : target.func_213302_cg();
            if (((BeamData)this.getData()).getVariation() == -1.0f) {
                ((BeamData)this.getData()).setVariation(0.7f);
            }
        }
        for (int segment = 1; segment <= ((BeamData)this.getData()).getSegments(); ++segment) {
            for (int i = 0; i < ((BeamData)this.getData()).getPower() / 10 + 5; ++i) {
                Vector3d vec = ParticleMathHelper.generatePointInSphere(trueVariation, w.field_73012_v);
                mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery((double)trueStart[0] + vec.field_72450_a, (double)trueStart[1] + vec.field_72448_b, (double)trueStart[2] + vec.field_72449_c, 0.0, 0.0, 0.0, ((BeamData)this.getData()).makeEffect(this).setStartPos((double)trueStart[0] + vec.field_72450_a, (double)trueStart[1] + vec.field_72448_b, (double)trueStart[2] + vec.field_72449_c).setHideTicks(segment + w.field_73012_v.nextInt(3), true).setNoise(0.0)));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        double completeFactor = (effect.travelledDistance + (RandomHelper.getRandom().nextDouble() - 0.5)) / effect.totalDistance;
        if (completeFactor > 1.0) {
            return;
        }
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        float newX = (float)(particle.getX() + ((double)this.getStartPos()[0] + (double)(this.getEndPos()[0] - this.getStartPos()[0]) * completeFactor - particle.getX()) * (double)(1.0f - ((BeamData)this.getData()).getVariation()));
        float newY = (float)(particle.getY() + ((double)this.getStartPos()[1] + (double)(this.getEndPos()[1] - this.getStartPos()[1]) * completeFactor - particle.getY()) * (double)(1.0f - ((BeamData)this.getData()).getVariation()));
        float newZ = (float)(particle.getZ() + ((double)this.getStartPos()[2] + (double)(this.getEndPos()[2] - this.getStartPos()[2]) * completeFactor - particle.getZ()) * (double)(1.0f - ((BeamData)this.getData()).getVariation()));
        particle.func_187109_b(newX, newY, newZ);
        effect.travelledDistance += Math.abs(Math.sqrt(Math.pow(newX - this.getEndPos()[0], 2.0) + Math.pow(newY - this.getEndPos()[1], 2.0) + Math.pow(newZ - this.getEndPos()[2], 2.0)) - Math.sqrt(Math.pow(particle.getPrevX() - (double)this.getEndPos()[0], 2.0) + Math.pow(particle.getPrevY() - (double)this.getEndPos()[1], 2.0) + Math.pow(particle.getPrevZ() - (double)this.getEndPos()[2], 2.0)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
        if (!((BeamData)this.getData()).isInverted()) {
            particle.setMotion(RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5, RandomHelper.getRandom().nextDouble() - 0.5);
            particle.setMotion(particle.getMotionX() * 0.05, particle.getMotionY() * 0.05, particle.getMotionZ() * 0.05);
        } else {
            particle.func_187112_i();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }

    public static class BeamData
    extends StandardParticleAnimationData {
        private int segments = 15;
        private float variation = -1.0f;
        private boolean inverted = false;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.getSpeed() == -1.0f) {
                this.setSpeed(0.75f + (RandomHelper.getRandom().nextFloat() - 0.5f) / 5.0f);
            }
            if (this.variation == -1.0f && !this.inverted) {
                this.variation = 0.25f;
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            buf.writeByte(this.segments);
            buf.writeBoolean(this.inverted);
            buf.writeBoolean(this.variation != -1.0f);
            if (this.variation != -1.0f) {
                buf.writeFloat(this.variation);
            }
            super.writeToByteBuffer(buf);
        }

        @Override
        public BeamData readFromByteBuffer(ByteBuf buf) {
            this.segments = buf.readUnsignedByte();
            this.inverted = buf.readBoolean();
            if (buf.readBoolean()) {
                this.variation = buf.readFloat();
            }
            return (BeamData)super.readFromByteBuffer(buf);
        }

        @Override
        public EffectType getEffectEnum() {
            return EffectType.BEAM;
        }

        public BeamData setSegments(int segments) {
            this.segments = segments;
            return this;
        }

        public BeamData setVariation(float variation) {
            this.variation = variation;
            return this;
        }

        public BeamData setInverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public int getSegments() {
            return this.segments;
        }

        public float getVariation() {
            return this.variation;
        }

        public boolean isInverted() {
            return this.inverted;
        }
    }
}

